/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestClearPrivilegesCacheAction
extends SecurityBaseRestHandler {
    public RestClearPrivilegesCacheAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "security_clear_privileges_cache_action";
    }

    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_security/privilege/{application}/_clear_cache"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] applicationNames = request.paramAsStringArrayOrEmptyIfAll("application");
        ClearSecurityCacheRequest req = new ClearSecurityCacheRequest().cacheName("application_privileges").keys(applicationNames);
        return channel -> client.execute((ActionType)ClearSecurityCacheAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

