/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.operator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.collect.Set;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

public class FileOperatorUsersStore {
    private static final Logger logger = LogManager.getLogger(FileOperatorUsersStore.class);
    private final Path file;
    private volatile OperatorUsersDescriptor operatorUsersDescriptor;
    private static final OperatorUsersDescriptor EMPTY_OPERATOR_USERS_DESCRIPTOR = new OperatorUsersDescriptor(org.elasticsearch.common.collect.List.of());
    private static final ConstructingObjectParser<Group, Void> GROUP_PARSER = new ConstructingObjectParser("operator_privileges.operator.group", false, arr -> new Group(Set.copyOf((Collection)((List)arr[0])), (String)arr[1], (String)arr[2], (String)arr[3]));
    private static final ConstructingObjectParser<OperatorUsersDescriptor, Void> OPERATOR_USER_PARSER = new ConstructingObjectParser("operator_privileges.operator", false, arr -> new OperatorUsersDescriptor((List)arr[0]));

    public FileOperatorUsersStore(Environment env, ResourceWatcherService watcherService) {
        this.file = XPackPlugin.resolveConfigFile((Environment)env, (String)"operator_users.yml");
        this.operatorUsersDescriptor = FileOperatorUsersStore.parseFile(this.file, logger);
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to start watching the operator users file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    public boolean isOperatorUser(Authentication authentication) {
        if (authentication.getUser().isRunAs()) {
            return false;
        }
        if (User.isInternal((User)authentication.getUser())) {
            return true;
        }
        return this.operatorUsersDescriptor.groups.stream().anyMatch(group -> {
            Authentication.RealmRef realm = authentication.getSourceRealm();
            return ((Group)group).usernames.contains(authentication.getUser().principal()) && ((Group)group).authenticationType == authentication.getAuthenticationType() && realm.getType().equals(((Group)group).realmType) && (((Group)group).realmName == null || ((Group)group).realmName.equals(realm.getName()));
        });
    }

    public OperatorUsersDescriptor getOperatorUsersDescriptor() {
        return this.operatorUsersDescriptor;
    }

    public static OperatorUsersDescriptor parseFile(Path file, Logger logger) {
        OperatorUsersDescriptor operatorUsersDescriptor;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                logger.warn("Operator privileges [{}] is enabled, but operator user file does not exist. No user will be able to perform operator-only actions.", (Object)OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.getKey());
                return EMPTY_OPERATOR_USERS_DESCRIPTOR;
            }
            logger.debug("Reading operator users file [{}]", (Object)file.toAbsolutePath());
            InputStream in = Files.newInputStream(file, StandardOpenOption.READ);
            try {
                operatorUsersDescriptor = FileOperatorUsersStore.parseConfig(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    logger.error((Message)new ParameterizedMessage("Failed to parse operator users file [{}].", (Object)file), (Throwable)e);
                    throw new ElasticsearchParseException("Error parsing operator users file [{}]", (Throwable)e, new Object[]{file.toAbsolutePath()});
                }
            }
            in.close();
        }
        return operatorUsersDescriptor;
    }

    public static OperatorUsersDescriptor parseConfig(InputStream in) throws IOException {
        try (XContentParser parser = FileOperatorUsersStore.yamlParser(in);){
            OperatorUsersDescriptor operatorUsersDescriptor = (OperatorUsersDescriptor)OPERATOR_USER_PARSER.parse(parser, null);
            logger.trace("Parsed: [{}]", (Object)operatorUsersDescriptor);
            OperatorUsersDescriptor operatorUsersDescriptor2 = operatorUsersDescriptor;
            return operatorUsersDescriptor2;
        }
    }

    private static XContentParser yamlParser(InputStream in) throws IOException {
        return XContentType.YAML.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, in);
    }

    static {
        GROUP_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), Fields.USERNAMES);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.REALM_NAME);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.REALM_TYPE);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.AUTH_TYPE);
        OPERATOR_USER_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ignore) -> (Group)GROUP_PARSER.parse(parser, null), Fields.OPERATOR);
    }

    static final class OperatorUsersDescriptor {
        private final List<Group> groups;

        private OperatorUsersDescriptor(List<Group> groups) {
            this.groups = groups;
        }

        List<Group> getGroups() {
            return this.groups;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorUsersDescriptor that = (OperatorUsersDescriptor)o;
            return this.groups.equals(that.groups);
        }

        public int hashCode() {
            return Objects.hash(this.groups);
        }

        public String toString() {
            return "OperatorUsersDescriptor{groups=" + this.groups + '}';
        }
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileOperatorUsersStore.this.file)) {
                OperatorUsersDescriptor newDescriptor = FileOperatorUsersStore.parseFile(file, logger);
                if (!FileOperatorUsersStore.this.operatorUsersDescriptor.equals(newDescriptor)) {
                    logger.info("operator users file [{}] changed. updating operator users...", (Object)file.toAbsolutePath());
                    FileOperatorUsersStore.this.operatorUsersDescriptor = newDescriptor;
                }
            }
        }
    }

    static final class Group {
        private static final java.util.Set<String> SINGLETON_REALM_TYPES = Set.of((Object[])new String[]{"file", "native", "reserved"});
        private final java.util.Set<String> usernames;
        private final String realmName;
        private final String realmType;
        private final Authentication.AuthenticationType authenticationType;

        Group(java.util.Set<String> usernames) {
            this(usernames, null);
        }

        Group(java.util.Set<String> usernames, @Nullable String realmName) {
            this(usernames, realmName, null, null);
        }

        Group(java.util.Set<String> usernames, @Nullable String realmName, @Nullable String realmType, @Nullable String authenticationType) {
            this.usernames = usernames;
            this.realmName = realmName;
            this.realmType = realmType == null ? "file" : realmType;
            this.authenticationType = authenticationType == null ? Authentication.AuthenticationType.REALM : Authentication.AuthenticationType.valueOf((String)authenticationType.toUpperCase(Locale.ROOT));
            this.validate();
        }

        private void validate() {
            ValidationException validationException = new ValidationException();
            if (!"file".equals(this.realmType)) {
                validationException.addValidationError("[realm_type] only supports [file]");
            }
            if (Authentication.AuthenticationType.REALM != this.authenticationType) {
                validationException.addValidationError("[auth_type] only supports [realm]");
            }
            if (this.realmName == null && !SINGLETON_REALM_TYPES.contains(this.realmType)) {
                validationException.addValidationError("[realm_name] must be specified for realm types other than [" + Strings.collectionToCommaDelimitedString(SINGLETON_REALM_TYPES) + "]");
            }
            if (!validationException.validationErrors().isEmpty()) {
                throw validationException;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Group[");
            sb.append("usernames=").append(this.usernames);
            if (this.realmName != null) {
                sb.append(", realm_name=").append(this.realmName);
            }
            if (this.realmType != null) {
                sb.append(", realm_type=").append(this.realmType);
            }
            if (this.authenticationType != null) {
                sb.append(", auth_type=").append(this.authenticationType.name().toLowerCase(Locale.ROOT));
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.usernames.equals(group.usernames) && Objects.equals(this.realmName, group.realmName) && this.realmType.equals(group.realmType) && this.authenticationType == group.authenticationType;
        }

        public int hashCode() {
            return Objects.hash(this.usernames, this.realmName, this.realmType, this.authenticationType);
        }
    }

    public static interface Fields {
        public static final ParseField OPERATOR = new ParseField("operator", new String[0]);
        public static final ParseField USERNAMES = new ParseField("usernames", new String[0]);
        public static final ParseField REALM_NAME = new ParseField("realm_name", new String[0]);
        public static final ParseField REALM_TYPE = new ParseField("realm_type", new String[0]);
        public static final ParseField AUTH_TYPE = new ParseField("auth_type", new String[0]);
    }
}

