/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.MemoizedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

abstract class FieldAndDocumentLevelSecurityRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final Logger logger;

    FieldAndDocumentLevelSecurityRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @Override
    public void intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<Void> listener) {
        if (requestInfo.getRequest() instanceof IndicesRequest && !TransportActionProxy.isProxyAction((String)requestInfo.getAction())) {
            IndicesRequest indicesRequest = (IndicesRequest)requestInfo.getRequest();
            boolean shouldIntercept = this.licenseState.isSecurityEnabled();
            MemoizedSupplier licenseChecker = new MemoizedSupplier(() -> this.licenseState.checkFeature(XPackLicenseState.Feature.SECURITY_DLS_FLS));
            if (this.supports(indicesRequest) && shouldIntercept) {
                Object[] requestIndices;
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
                boolean fieldLevelSecurityEnabled = false;
                boolean documentLevelSecurityEnabled = false;
                for (String string : requestIndices = this.requestIndices(indicesRequest)) {
                    IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(string);
                    if (indexAccessControl == null) continue;
                    fieldLevelSecurityEnabled = fieldLevelSecurityEnabled || indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                    boolean bl = documentLevelSecurityEnabled = documentLevelSecurityEnabled || indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions();
                    if (fieldLevelSecurityEnabled && documentLevelSecurityEnabled) break;
                }
                if ((fieldLevelSecurityEnabled || documentLevelSecurityEnabled) && ((Boolean)licenseChecker.get()).booleanValue()) {
                    this.logger.trace("intercepted request for indices [{}] with field level access controls [{}] document level access controls [{}]. disabling conflicting features", (Object)Strings.arrayToDelimitedString((Object[])requestIndices, (String)","), (Object)fieldLevelSecurityEnabled, (Object)documentLevelSecurityEnabled);
                    this.disableFeatures(indicesRequest, fieldLevelSecurityEnabled, documentLevelSecurityEnabled, listener);
                    return;
                }
                this.logger.trace("intercepted request for indices [{}] without field or document level access controls", (Object)Strings.arrayToDelimitedString((Object[])requestIndices, (String)","));
            }
        }
        listener.onResponse(null);
    }

    String[] requestIndices(IndicesRequest indicesRequest) {
        return indicesRequest.indices();
    }

    abstract void disableFeatures(IndicesRequest var1, boolean var2, boolean var3, ActionListener<Void> var4);

    abstract boolean supports(IndicesRequest var1);
}

