/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.oidc;

import com.nimbusds.oauth2.sdk.id.Issuer;
import java.net.URI;
import java.util.Objects;
import org.elasticsearch.common.Nullable;

public class OpenIdConnectProviderConfiguration {
    private final URI authorizationEndpoint;
    private final URI tokenEndpoint;
    private final URI userinfoEndpoint;
    private final URI endsessionEndpoint;
    private final Issuer issuer;
    private final String jwkSetPath;

    public OpenIdConnectProviderConfiguration(Issuer issuer, String jwkSetPath, URI authorizationEndpoint, @Nullable URI tokenEndpoint, @Nullable URI userinfoEndpoint, @Nullable URI endsessionEndpoint) {
        this.authorizationEndpoint = Objects.requireNonNull(authorizationEndpoint, "Authorization Endpoint must be provided");
        this.tokenEndpoint = tokenEndpoint;
        this.userinfoEndpoint = userinfoEndpoint;
        this.endsessionEndpoint = endsessionEndpoint;
        this.issuer = Objects.requireNonNull(issuer, "OP Issuer must be provided");
        this.jwkSetPath = Objects.requireNonNull(jwkSetPath, "jwkSetUrl must be provided");
    }

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public URI getEndsessionEndpoint() {
        return this.endsessionEndpoint;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public String getJwkSetPath() {
        return this.jwkSetPath;
    }
}

