/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.RoundRobinDNSServerSet;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import java.util.Locale;
import java.util.function.Function;
import javax.net.SocketFactory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapLoadBalancingSettings;

public enum LdapLoadBalancing {
    FAILOVER{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, RealmConfig realmConfig, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            FailoverServerSet serverSet = new FailoverServerSet(addresses, ports, socketFactory, options);
            serverSet.setReOrderOnFailover(true);
            return serverSet;
        }
    }
    ,
    ROUND_ROBIN{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, RealmConfig realmConfig, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            return new RoundRobinServerSet(addresses, ports, socketFactory, options);
        }
    }
    ,
    DNS_ROUND_ROBIN{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, RealmConfig realmConfig, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            if (addresses.length != 1) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a single url");
            }
            if (InetAddresses.isInetAddress((String)addresses[0])) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a DNS name");
            }
            TimeValue dnsTtl = (TimeValue)realmConfig.getSetting(LdapLoadBalancingSettings.CACHE_TTL_SETTING);
            return new RoundRobinDNSServerSet(addresses[0], ports[0], RoundRobinDNSServerSet.AddressSelectionMode.ROUND_ROBIN, dnsTtl.millis(), null, socketFactory, options);
        }
    }
    ,
    DNS_FAILOVER{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, RealmConfig realmConfig, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            if (addresses.length != 1) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a single url");
            }
            if (InetAddresses.isInetAddress((String)addresses[0])) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a DNS name");
            }
            TimeValue dnsTtl = (TimeValue)realmConfig.getSetting(LdapLoadBalancingSettings.CACHE_TTL_SETTING);
            return new RoundRobinDNSServerSet(addresses[0], ports[0], RoundRobinDNSServerSet.AddressSelectionMode.FAILOVER, dnsTtl.millis(), null, socketFactory, options);
        }
    };

    public static final LdapLoadBalancing LOAD_BALANCE_TYPE_DEFAULT;

    abstract ServerSet buildServerSet(String[] var1, int[] var2, RealmConfig var3, @Nullable SocketFactory var4, @Nullable LDAPConnectionOptions var5);

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LdapLoadBalancing resolve(RealmConfig realmConfig) {
        String type = (String)realmConfig.getSetting(LdapLoadBalancingSettings.LOAD_BALANCE_TYPE_SETTING);
        if (Strings.isNullOrEmpty((String)type)) {
            return LOAD_BALANCE_TYPE_DEFAULT;
        }
        try {
            return LdapLoadBalancing.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ilae) {
            throw new IllegalArgumentException("unknown load balance type [" + type + "] in setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Function)LdapLoadBalancingSettings.LOAD_BALANCE_TYPE_SETTING) + "]", ilae);
        }
    }

    public static ServerSet serverSet(String[] addresses, int[] ports, RealmConfig realmConfig, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
        LdapLoadBalancing loadBalancing = LdapLoadBalancing.resolve(realmConfig);
        return loadBalancing.buildServerSet(addresses, ports, realmConfig, socketFactory, options);
    }

    static {
        LOAD_BALANCE_TYPE_DEFAULT = FAILOVER;
    }
}

