/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class ExpiredApiKeysRemover
extends AbstractRunnable {
    public static final Duration EXPIRED_API_KEYS_RETENTION_PERIOD = Duration.ofDays(7L);
    private static final Logger logger = LogManager.getLogger(ExpiredApiKeysRemover.class);
    private final Client client;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final TimeValue timeout;

    ExpiredApiKeysRemover(Settings settings, Client client) {
        this.client = client;
        this.timeout = (TimeValue)ApiKeyService.DELETE_TIMEOUT.get(settings);
    }

    public void doRun() {
        DeleteByQueryRequest expiredDbq = new DeleteByQueryRequest(new String[]{".security"});
        if (this.timeout != TimeValue.MINUS_ONE) {
            expiredDbq.setTimeout(this.timeout);
            expiredDbq.getSearchRequest().source().timeout(this.timeout);
        }
        Instant now = Instant.now();
        expiredDbq.setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"api_key"})).should((QueryBuilder)QueryBuilders.termsQuery((String)"api_key_invalidated", (Object[])new Object[]{true})).should((QueryBuilder)QueryBuilders.rangeQuery((String)"expiration_time").lte((Object)now.minus(EXPIRED_API_KEYS_RETENTION_PERIOD).toEpochMilli())).minimumShouldMatch(1));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)expiredDbq, (ActionListener)ActionListener.wrap(r -> {
            this.debugDbqResponse((BulkByScrollResponse)r);
            this.markComplete();
        }, this::onFailure));
    }

    void submit(ThreadPool threadPool) {
        if (this.inProgress.compareAndSet(false, true)) {
            threadPool.executor("generic").submit((Runnable)((Object)this));
        }
    }

    private void debugDbqResponse(BulkByScrollResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("delete by query of api keys finished with [{}] deletions, [{}] bulk failures, [{}] search failures", (Object)response.getDeleted(), (Object)response.getBulkFailures().size(), (Object)response.getSearchFailures().size());
            for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                logger.debug((Message)new ParameterizedMessage("deletion failed for index [{}], type [{}], id [{}]", new Object[]{failure.getIndex(), failure.getType(), failure.getId()}), (Throwable)failure.getCause());
            }
            for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                logger.debug((Message)new ParameterizedMessage("search failed for index [{}], shard [{}] on node [{}]", new Object[]{failure.getIndex(), failure.getShardId(), failure.getNodeId()}), failure.getReason());
            }
        }
    }

    boolean isExpirationInProgress() {
        return this.inProgress.get();
    }

    public void onFailure(Exception e) {
        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
            logger.debug("failed to delete expired or invalidated api keys", (Throwable)e);
        } else {
            logger.error("failed to delete expired or invalidated api keys", (Throwable)e);
        }
        this.markComplete();
    }

    private void markComplete() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new IllegalStateException("in progress was set to false but should have been true!");
        }
    }
}

