/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.percolator.PercolateQueryBuilder;
import org.elasticsearch.percolator.PercolatorFieldMapper;
import org.elasticsearch.percolator.PercolatorHighlightSubFetchPhase;
import org.elasticsearch.percolator.PercolatorMatchedSlotSubFetchPhase;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.fetch.FetchSubPhase;

public class PercolatorPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    private final Settings settings;

    public PercolatorPlugin(Settings settings) {
        this.settings = settings;
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("percolate", PercolateQueryBuilder::new, PercolateQueryBuilder::fromXContent));
    }

    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Arrays.asList(new PercolatorMatchedSlotSubFetchPhase(), new PercolatorHighlightSubFetchPhase(this.settings, context.getHighlighters()));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING, PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("percolator", new PercolatorFieldMapper.TypeParser());
    }
}

