/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;

final class PercolateQuery
extends Query
implements Accountable {
    public static final float MATCH_COST = 1000.0f;
    private final String documentType;
    private final QueryStore queryStore;
    private final BytesReference documentSource;
    private final Query candidateMatchesQuery;
    private final Query verifiedMatchesQuery;
    private final IndexSearcher percolatorIndexSearcher;

    PercolateQuery(String documentType, QueryStore queryStore, BytesReference documentSource, Query candidateMatchesQuery, IndexSearcher percolatorIndexSearcher, Query verifiedMatchesQuery) {
        this.documentType = Objects.requireNonNull(documentType);
        this.documentSource = Objects.requireNonNull(documentSource);
        this.candidateMatchesQuery = Objects.requireNonNull(candidateMatchesQuery);
        this.queryStore = Objects.requireNonNull(queryStore);
        this.percolatorIndexSearcher = Objects.requireNonNull(percolatorIndexSearcher);
        this.verifiedMatchesQuery = Objects.requireNonNull(verifiedMatchesQuery);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.candidateMatchesQuery.rewrite(reader);
        if (rewritten != this.candidateMatchesQuery) {
            return new PercolateQuery(this.documentType, this.queryStore, this.documentSource, rewritten, this.percolatorIndexSearcher, this.verifiedMatchesQuery);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, final boolean needsScores, float boost) throws IOException {
        final Weight verifiedMatchesWeight = this.verifiedMatchesQuery.createWeight(searcher, false, boost);
        final Weight candidateMatchesWeight = this.candidateMatchesQuery.createWeight(searcher, false, boost);
        return new Weight(this){

            public void extractTerms(Set<Term> set) {
            }

            public Explanation explain(LeafReaderContext leafReaderContext, int docId) throws IOException {
                TwoPhaseIterator twoPhaseIterator;
                int result;
                Scorer scorer = this.scorer(leafReaderContext);
                if (scorer != null && (result = (twoPhaseIterator = scorer.twoPhaseIterator()).approximation().advance(docId)) == docId && twoPhaseIterator.matches()) {
                    if (needsScores) {
                        CheckedFunction<Integer, Query, IOException> percolatorQueries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                        Query query = (Query)percolatorQueries.apply((Object)docId);
                        Explanation detail = PercolateQuery.this.percolatorIndexSearcher.explain(query, 0);
                        return Explanation.match((float)scorer.score(), (String)"PercolateQuery", (Explanation[])new Explanation[]{detail});
                    }
                    return Explanation.match((float)scorer.score(), (String)"PercolateQuery", (Explanation[])new Explanation[0]);
                }
                return Explanation.noMatch((String)"PercolateQuery", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                Scorer approximation = candidateMatchesWeight.scorer(leafReaderContext);
                if (approximation == null) {
                    return null;
                }
                CheckedFunction<Integer, Query, IOException> queries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                if (needsScores) {
                    return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){
                        float score;

                        @Override
                        boolean matchDocId(int docId) throws IOException {
                            Query query = (Query)this.percolatorQueries.apply((Object)docId);
                            if (query != null) {
                                TopDocs topDocs = this.percolatorIndexSearcher.search(query, 1);
                                if (topDocs.totalHits > 0) {
                                    this.score = topDocs.scoreDocs[0].score;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }

                        public float score() throws IOException {
                            return this.score;
                        }
                    };
                }
                Scorer verifiedDocsScorer = verifiedMatchesWeight.scorer(leafReaderContext);
                final Bits verifiedDocsBits = Lucene.asSequentialAccessBits((int)leafReaderContext.reader().maxDoc(), (Scorer)verifiedDocsScorer);
                return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){

                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    boolean matchDocId(int docId) throws IOException {
                        if (verifiedDocsBits.get(docId)) {
                            return true;
                        }
                        Query query = (Query)this.percolatorQueries.apply((Object)docId);
                        return query != null && Lucene.exists((IndexSearcher)this.percolatorIndexSearcher, (Query)query);
                    }
                };
            }
        };
    }

    public IndexSearcher getPercolatorIndexSearcher() {
        return this.percolatorIndexSearcher;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public BytesReference getDocumentSource() {
        return this.documentSource;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString(String s) {
        return "PercolateQuery{document_type={" + this.documentType + "},document_source={" + this.documentSource.utf8ToString() + "},inner={" + this.candidateMatchesQuery.toString(s) + "}}";
    }

    public long ramBytesUsed() {
        return this.documentSource.ramBytesUsed();
    }

    static abstract class BaseScorer
    extends Scorer {
        final Scorer approximation;
        final CheckedFunction<Integer, Query, IOException> percolatorQueries;
        final IndexSearcher percolatorIndexSearcher;

        BaseScorer(Weight weight, Scorer approximation, CheckedFunction<Integer, Query, IOException> percolatorQueries, IndexSearcher percolatorIndexSearcher) {
            super(weight);
            this.approximation = approximation;
            this.percolatorQueries = percolatorQueries;
            this.percolatorIndexSearcher = percolatorIndexSearcher;
        }

        public final DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
        }

        public final TwoPhaseIterator twoPhaseIterator() {
            return new TwoPhaseIterator(this.approximation.iterator()){

                public boolean matches() throws IOException {
                    return this.matchDocId(this.approximation.docID());
                }

                public float matchCost() {
                    return 1000.0f;
                }
            };
        }

        public final int freq() throws IOException {
            return this.approximation.freq();
        }

        public final int docID() {
            return this.approximation.docID();
        }

        abstract boolean matchDocId(int var1) throws IOException;
    }

    @FunctionalInterface
    static interface QueryStore {
        public CheckedFunction<Integer, Query, IOException> getQueries(LeafReaderContext var1) throws IOException;
    }
}

