/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.pl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pl.PolishAnalyzer;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.egothor.stemmer.Trie;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class PolishStemTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final StempelStemmer stemmer;

    @Inject
    public PolishStemTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Trie tire;
        try {
            tire = StempelStemmer.load((InputStream)PolishAnalyzer.class.getResourceAsStream("stemmer_20000.tbl"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load default stemming tables", ex);
        }
        this.stemmer = new StempelStemmer(tire);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new StempelFilter(tokenStream, this.stemmer);
    }
}

