/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Normalizer2;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class IcuNormalizerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final String name;

    @Inject
    public IcuNormalizerTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.name = settings.get("name", "nfkc_cf");
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUNormalizer2Filter(tokenStream, Normalizer2.getInstance(null, (String)this.name, (Normalizer2.Mode)Normalizer2.Mode.COMPOSE));
    }
}

