/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.xcontent.MediaType;

public class MediaTypeRegistry<T extends MediaType> {
    private Map<String, T> queryParamToMediaType = new HashMap<String, T>();
    private Map<String, T> typeWithSubtypeToMediaType = new HashMap<String, T>();
    private Map<String, Map<String, Pattern>> parametersMap = new HashMap<String, Map<String, Pattern>>();

    public T queryParamToMediaType(String format) {
        if (format == null) {
            return null;
        }
        return (T)((MediaType)this.queryParamToMediaType.get(format.toLowerCase(Locale.ROOT)));
    }

    public T typeWithSubtypeToMediaType(String typeWithSubtype) {
        return (T)((MediaType)this.typeWithSubtypeToMediaType.get(typeWithSubtype.toLowerCase(Locale.ROOT)));
    }

    public Map<String, Pattern> parametersFor(String typeWithSubtype) {
        return this.parametersMap.get(typeWithSubtype);
    }

    public MediaTypeRegistry<T> register(T[] mediaTypes) {
        for (T mediaType : mediaTypes) {
            Set<MediaType.HeaderValue> tuples = mediaType.headerValues();
            for (MediaType.HeaderValue headerValue : tuples) {
                this.queryParamToMediaType.put(mediaType.queryParameter(), mediaType);
                this.typeWithSubtypeToMediaType.put((String)headerValue.v1(), mediaType);
                this.parametersMap.put((String)headerValue.v1(), this.convertPatterns((Map)headerValue.v2()));
            }
        }
        return this;
    }

    private Map<String, Pattern> convertPatterns(Map<String, String> paramNameAndValueRegex) {
        HashMap<String, Pattern> parametersForMediaType = new HashMap<String, Pattern>(paramNameAndValueRegex.size());
        for (Map.Entry<String, String> params : paramNameAndValueRegex.entrySet()) {
            String parameterName = params.getKey().toLowerCase(Locale.ROOT);
            String parameterRegex = params.getValue();
            Pattern pattern = Pattern.compile(parameterRegex, 2);
            parametersForMediaType.put(parameterName, pattern);
        }
        return parametersForMediaType;
    }
}

