/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Collection;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.MergingDigest;
import org.elasticsearch.tdigest.SortingDigest;
import org.elasticsearch.tdigest.TDigest;
import org.elasticsearch.tdigest.arrays.TDigestArrays;

public class HybridDigest
extends AbstractTDigest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(HybridDigest.class);
    private final TDigestArrays arrays;
    private boolean closed = false;
    private final double compression;
    private final long maxSortingSize;
    private SortingDigest sortingDigest;
    private MergingDigest mergingDigest;

    static HybridDigest create(TDigestArrays arrays, double compression) {
        arrays.adjustBreaker(SHALLOW_SIZE);
        try {
            return new HybridDigest(arrays, compression);
        }
        catch (Exception e) {
            arrays.adjustBreaker(-SHALLOW_SIZE);
            throw e;
        }
    }

    private HybridDigest(TDigestArrays arrays, double compression, long maxSortingSize) {
        this.arrays = arrays;
        this.compression = compression;
        this.maxSortingSize = maxSortingSize;
        this.sortingDigest = TDigest.createSortingDigest(arrays);
    }

    private HybridDigest(TDigestArrays arrays, double compression) {
        this(arrays, compression, Math.round(compression) * 20L);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + (this.sortingDigest != null ? this.sortingDigest.ramBytesUsed() : 0L) + (this.mergingDigest != null ? this.mergingDigest.ramBytesUsed() : 0L);
    }

    @Override
    public void add(double x, long w) {
        this.reserve(w);
        if (this.mergingDigest != null) {
            this.mergingDigest.add(x, w);
        } else {
            this.sortingDigest.add(x, w);
        }
    }

    @Override
    public void add(TDigest other) {
        this.reserve(other.size());
        if (this.mergingDigest != null) {
            this.mergingDigest.add(other);
        } else {
            this.sortingDigest.add(other);
        }
    }

    @Override
    public void reserve(long size) {
        if (this.mergingDigest != null) {
            this.mergingDigest.reserve(size);
            return;
        }
        assert (this.sortingDigest != null);
        if (this.sortingDigest.size() + size >= this.maxSortingSize) {
            this.mergingDigest = TDigest.createMergingDigest(this.arrays, this.compression);
            for (int i = 0; i < this.sortingDigest.values.size(); ++i) {
                this.mergingDigest.add(this.sortingDigest.values.get(i));
            }
            this.mergingDigest.reserve(size);
            this.sortingDigest.close();
            this.sortingDigest = null;
        } else {
            this.sortingDigest.reserve(size);
        }
    }

    @Override
    public void compress() {
        if (this.mergingDigest != null) {
            this.mergingDigest.compress();
        } else {
            this.sortingDigest.compress();
        }
    }

    @Override
    public long size() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.size();
        }
        return this.sortingDigest.size();
    }

    @Override
    public double cdf(double x) {
        if (this.mergingDigest != null) {
            return this.mergingDigest.cdf(x);
        }
        return this.sortingDigest.cdf(x);
    }

    @Override
    public double quantile(double q) {
        if (this.mergingDigest != null) {
            return this.mergingDigest.quantile(q);
        }
        return this.sortingDigest.quantile(q);
    }

    @Override
    public Collection<Centroid> centroids() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.centroids();
        }
        return this.sortingDigest.centroids();
    }

    @Override
    public double compression() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.compression();
        }
        return this.sortingDigest.compression();
    }

    @Override
    public int centroidCount() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.centroidCount();
        }
        return this.sortingDigest.centroidCount();
    }

    @Override
    public double getMin() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.getMin();
        }
        return this.sortingDigest.getMin();
    }

    @Override
    public double getMax() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.getMax();
        }
        return this.sortingDigest.getMax();
    }

    @Override
    public int byteSize() {
        if (this.mergingDigest != null) {
            return this.mergingDigest.byteSize();
        }
        return this.sortingDigest.byteSize();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.arrays.adjustBreaker(-SHALLOW_SIZE);
            Releasables.close((Releasable[])new Releasable[]{this.sortingDigest, this.mergingDigest});
        }
    }
}

