/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.common.ssl.SslDiagnostics;

public final class DiagnosticTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final Supplier<String> contextName;
    private final DiagnosticLogger logger;
    private final Map<String, List<X509Certificate>> issuers;

    public DiagnosticTrustManager(X509ExtendedTrustManager delegate, Supplier<String> contextName, DiagnosticLogger logger) {
        this.delegate = delegate;
        this.contextName = contextName;
        this.logger = logger;
        this.issuers = Stream.of(delegate.getAcceptedIssuers()).collect(Collectors.toMap(cert -> cert.getSubjectX500Principal().getName(), List::of, (a, b) -> {
            ArrayList list = new ArrayList(a.size() + b.size());
            list.addAll(a);
            list.addAll(b);
            return list;
        }));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.CLIENT, DiagnosticTrustManager.session(socket));
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.SERVER, DiagnosticTrustManager.session(socket));
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.CLIENT, DiagnosticTrustManager.session(engine));
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.SERVER, DiagnosticTrustManager.session(engine));
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.CLIENT, null);
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.diagnose(e, chain, SslDiagnostics.PeerType.SERVER, null);
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    private void diagnose(CertificateException cause, X509Certificate[] chain, SslDiagnostics.PeerType peerType, SSLSession session) {
        String diagnostic = SslDiagnostics.getTrustDiagnosticFailure(chain, peerType, session, this.contextName.get(), this.issuers);
        this.logger.warning(diagnostic, cause);
    }

    private static SSLSession session(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket ssl = (SSLSocket)socket;
            SSLSession handshakeSession = ssl.getHandshakeSession();
            if (handshakeSession == null) {
                return ssl.getSession();
            }
            return handshakeSession;
        }
        return null;
    }

    private static SSLSession session(SSLEngine engine) {
        return engine.getHandshakeSession();
    }

    @FunctionalInterface
    public static interface DiagnosticLogger {
        public void warning(String var1, GeneralSecurityException var2);
    }
}

