/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec;

import org.apache.lucene.index.VectorSimilarityFunction;

public enum VectorSimilarityType {
    COSINE,
    DOT_PRODUCT,
    EUCLIDEAN,
    MAXIMUM_INNER_PRODUCT;


    public static VectorSimilarityType of(VectorSimilarityFunction func) {
        return switch (func) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityFunction.EUCLIDEAN -> EUCLIDEAN;
            case VectorSimilarityFunction.COSINE -> COSINE;
            case VectorSimilarityFunction.DOT_PRODUCT -> DOT_PRODUCT;
            case VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT -> MAXIMUM_INNER_PRODUCT;
        };
    }

    public static VectorSimilarityFunction of(VectorSimilarityType func) {
        return switch (func.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> VectorSimilarityFunction.EUCLIDEAN;
            case 0 -> VectorSimilarityFunction.COSINE;
            case 1 -> VectorSimilarityFunction.DOT_PRODUCT;
            case 3 -> VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
        };
    }
}

