/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.util.Constants;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.simdvec.internal.vectorization.DefaultESVectorizationProvider;
import org.elasticsearch.simdvec.internal.vectorization.ESVectorUtilSupport;
import org.elasticsearch.simdvec.internal.vectorization.PanamaESVectorUtilSupport;
import org.elasticsearch.simdvec.internal.vectorization.PanamaESVectorizationProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ESVectorizationProvider {
    protected static final Logger logger = LogManager.getLogger(ESVectorizationProvider.class);

    public static ESVectorizationProvider getInstance() {
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    ESVectorizationProvider() {
    }

    public abstract ESVectorUtilSupport getVectorUtilSupport();

    static ESVectorizationProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        assert (runtimeVersion >= 21);
        if (runtimeVersion <= 23) {
            if (!Constants.IS_HOTSPOT_VM) {
                logger.warn("Java runtime is not using Hotspot VM; Java vector incubator API can't be enabled.");
                return new DefaultESVectorizationProvider();
            }
            Optional<Module> vectorMod = ESVectorizationProvider.lookupVectorModule();
            if (vectorMod.isEmpty()) {
                logger.warn("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new DefaultESVectorizationProvider();
            }
            vectorMod.ifPresent(ESVectorizationProvider.class.getModule()::addReads);
            PanamaESVectorizationProvider impl = new PanamaESVectorizationProvider();
            logger.info(String.format(Locale.ENGLISH, "Java vector incubator API enabled; uses preferredBitSize=%d", PanamaESVectorUtilSupport.VECTOR_BITSIZE));
            return impl;
        }
        logger.warn("You are running with unsupported Java " + runtimeVersion + ". To make full use of the Vector API, please update Elasticsearch.");
        return new DefaultESVectorizationProvider();
    }

    private static Optional<Module> lookupVectorModule() {
        return Optional.ofNullable(ESVectorizationProvider.class.getModule().getLayer()).orElse(ModuleLayer.boot()).findModule("jdk.incubator.vector");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Holder {
        static final ESVectorizationProvider INSTANCE = ESVectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

