/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import org.elasticsearch.nativeaccess.PosixConstants;
import org.elasticsearch.nativeaccess.PosixNativeAccess;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.SystemdLibrary;

class LinuxNativeAccess
extends PosixNativeAccess {
    Systemd systemd;

    LinuxNativeAccess(NativeLibraryProvider libraryProvider) {
        super("Linux", libraryProvider, new PosixConstants(-1L, 9, 1, 8));
        this.systemd = new Systemd(libraryProvider.getLibrary(SystemdLibrary.class));
    }

    @Override
    protected long getMaxThreads() {
        int rlimit_nproc = 6;
        return this.getRLimit(6, "max number of threads");
    }

    @Override
    public Systemd systemd() {
        return this.systemd;
    }

    @Override
    protected void logMemoryLimitInstructions() {
        String user = System.getProperty("user.name");
        logger.warn("These can be adjusted by modifying /etc/security/limits.conf, for example:\n\t# allow user '{}' mlockall\n\t{} soft memlock unlimited\n\t{} hard memlock unlimited", new Object[]{user, user, user});
        logger.warn("If you are logged in interactively, you will have to re-login for the new limits to take effect.");
    }
}

