/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.spark.sql.streaming.EsSinkStatus;
import org.elasticsearch.spark.sql.streaming.JobState;
import org.elasticsearch.spark.sql.streaming.TaskCommit;
import org.elasticsearch.spark.sql.streaming.TaskState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ty\u0001\u0011\t\u0011)A\u0005U!)\u0011\t\u0001C\u0001\u0005\"AQ\t\u0001EC\u0002\u0013\u0005a\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003[\u0001\u0011\u00051\fC\u0003o\u0001\u0011\u0005q\u000eC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"Ia\u000f\u0001a\u0001\u0002\u0004%\ta\u001e\u0005\nu\u0002\u0001\r\u0011!Q!\nMD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bBCA\u0001\u0001\u0001\u0007\t\u0011)Q\u0005g\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\u0011\u0001#R:D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u000b\u0005Q)\u0012!C:ue\u0016\fW.\u001b8h\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012!D3mCN$\u0018nY:fCJ\u001c\u0007NC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00012\u0013BA\u0014\"\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003%\u0019w.\\7ji2{w-F\u0001+!\rY3'N\u0007\u0002Y)\u0011A#\f\u0006\u0003]=\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Y\u0001$B\u0001\r2\u0015\t\u00114$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003i1\u00121\"T3uC\u0012\fG/\u0019'pOB\u0019\u0001E\u000e\u001d\n\u0005]\n#!B!se\u0006L\bCA\u001d;\u001b\u0005\u0019\u0012BA\u001e\u0014\u00051)5oU5oWN#\u0018\r^;t\u0003)\u0019w.\\7ji2{w\r\t\u0015\u0003\u0005y\u0002\"\u0001I \n\u0005\u0001\u000b#!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u00111\t\u0012\t\u0003s\u0001AQ\u0001K\u0002A\u0002)\na\u0001\\8hO\u0016\u0014X#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015a\u00027pO\u001eLgn\u001a\u0006\u0003\u0019F\nqaY8n[>t7/\u0003\u0002O\u0013\n\u0019Aj\\4)\u0005\u0011q\u0014aB5oSRTuN\u0019\u000b\u0003%V\u0003\"\u0001I*\n\u0005Q\u000b#\u0001B+oSRDQAV\u0003A\u0002]\u000b\u0001B[8c'R\fG/\u001a\t\u0003saK!!W\n\u0003\u0011){'m\u0015;bi\u0016\f\u0011bY8n[&$(j\u001c2\u0015\u0007IcV\fC\u0003W\r\u0001\u0007q\u000bC\u0003_\r\u0001\u0007q,A\u0006uCN\\7i\\7nSR\u001c\bc\u00011iW:\u0011\u0011M\u001a\b\u0003E\u0016l\u0011a\u0019\u0006\u0003Iv\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0005\u001d\f\u0013a\u00029bG.\fw-Z\u0005\u0003S*\u00141aU3r\u0015\t9\u0017\u0005\u0005\u0002:Y&\u0011Qn\u0005\u0002\u000b)\u0006\u001c8nQ8n[&$\u0018\u0001C1c_J$(j\u001c2\u0015\u0005I\u0003\b\"\u0002,\b\u0001\u00049\u0016A\u0004:fG>\u0014Hm],sSR$XM\\\u000b\u0002gB\u0011\u0001\u0005^\u0005\u0003k\u0006\u0012A\u0001T8oO\u0006\u0011\"/Z2pe\u0012\u001cxK]5ui\u0016tw\fJ3r)\t\u0011\u0006\u0010C\u0004z\u0013\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'A\bsK\u000e|'\u000fZ:Xe&$H/\u001a8!Q\tQa(\u0001\bfq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0002%\u0015DXmY;uS>t7\u000b^1si~#S-\u001d\u000b\u0003%~Dq!\u001f\u0007\u0002\u0002\u0003\u00071/A\bfq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;!Q\tia(\u0001\u0005j]&$H+Y:l)\r\u0011\u0016\u0011\u0002\u0005\b\u0003\u0017q\u0001\u0019AA\u0007\u0003%!\u0018m]6Ti\u0006$X\rE\u0002:\u0003\u001fI1!!\u0005\u0014\u0005%!\u0016m]6Ti\u0006$X-\u0001\u0006sK\u000e|'\u000fZ*fK:$\u0012AU\u0001\u000bG>lW.\u001b;UCN\\GcA6\u0002\u001c!9\u00111\u0002\tA\u0002\u00055\u0011!C1c_J$H+Y:l)\r\u0011\u0016\u0011\u0005\u0005\b\u0003\u0017\t\u0002\u0019AA\u0007\u0001")
public class EsCommitProtocol
implements scala.Serializable {
    private transient Log logger;
    private final transient MetadataLog<EsSinkStatus[]> commitLog;
    private transient long recordsWritten;
    private transient long executionStart;
    private volatile transient boolean bitmap$trans$0;

    public MetadataLog<EsSinkStatus[]> commitLog() {
        return this.commitLog;
    }

    private Log logger$lzycompute() {
        EsCommitProtocol esCommitProtocol = this;
        synchronized (esCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.logger = LogFactory.getLog(EsCommitProtocol.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Log logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void initJob(JobState jobState) {
        Assert.notNull(this.commitLog(), "commitLog cannot be null");
    }

    public void commitJob(JobState jobState, Seq<TaskCommit> taskCommits) {
        EsSinkStatus[] commits = (EsSinkStatus[])((TraversableOnce)taskCommits.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.statuses()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(EsSinkStatus.class));
        if (this.commitLog().add(jobState.batchId(), (Object)commits)) {
            this.logger().debug((Object)new StringBuilder(16).append("Committed batch ").append(jobState.batchId()).toString());
            return;
        }
        throw new IllegalStateException(new StringBuilder(32).append("Batch Id [").append(jobState.batchId()).append("] is already committed").toString());
    }

    public void abortJob(JobState jobState) {
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public void recordsWritten_$eq(long x$1) {
        this.recordsWritten = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public void executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void initTask(TaskState taskState) {
        this.recordsWritten_$eq(0L);
        this.executionStart_$eq(System.currentTimeMillis());
    }

    public void recordSeen() {
        this.recordsWritten_$eq(this.recordsWritten() + 1L);
    }

    public TaskCommit commitTask(TaskState taskState) {
        if (this.recordsWritten() > 0L) {
            return new TaskCommit((Option<EsSinkStatus>)new Some((Object)new EsSinkStatus(taskState.taskId(), this.executionStart(), taskState.resource(), this.recordsWritten())));
        }
        return new TaskCommit((Option<EsSinkStatus>)None$.MODULE$);
    }

    public void abortTask(TaskState taskState) {
    }

    public EsCommitProtocol(MetadataLog<EsSinkStatus[]> commitLog) {
        this.commitLog = commitLog;
    }
}

