/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;

public class CompositeSettings
extends Settings {
    private Settings writeSettings;
    private Deque<Settings> settingsList;

    public CompositeSettings(Collection<Settings> settings) {
        this.writeSettings = new PropertiesSettings();
        this.settingsList = new LinkedList<Settings>(settings);
    }

    private CompositeSettings(Settings writeSettings, LinkedList<Settings> settingsList) {
        this.writeSettings = writeSettings;
        this.settingsList = settingsList;
    }

    @Override
    public InputStream loadResource(String location) {
        return this.writeSettings.loadResource(location);
    }

    @Override
    public Settings copy() {
        Settings copiedWriteSettings = this.writeSettings.copy();
        LinkedList<Settings> copiedSettingsList = new LinkedList<Settings>();
        for (Settings settings : this.settingsList) {
            copiedSettingsList.add(settings.copy());
        }
        return new CompositeSettings(copiedWriteSettings, copiedSettingsList);
    }

    @Override
    public String getProperty(String name) {
        String value = this.writeSettings.getProperty(name);
        if (value == null) {
            Iterator<Settings> toCheck = this.settingsList.iterator();
            while (value == null && toCheck.hasNext()) {
                Settings next = toCheck.next();
                value = next.getProperty(name);
            }
        }
        return value;
    }

    @Override
    public void setProperty(String name, String value) {
        this.writeSettings.setProperty(name, value);
    }

    @Override
    public Properties asProperties() {
        Properties merged = new Properties();
        Iterator<Settings> settingsIterator = this.settingsList.descendingIterator();
        while (settingsIterator.hasNext()) {
            Settings next = settingsIterator.next();
            Properties props = next.asProperties();
            for (Object keyObject : props.keySet()) {
                String key = keyObject.toString();
                merged.setProperty(key, props.getProperty(key));
            }
        }
        Properties writeProperties = this.writeSettings.asProperties();
        for (Object keyObject : writeProperties.keySet()) {
            String key = keyObject.toString();
            merged.setProperty(key, writeProperties.getProperty(key));
        }
        return merged;
    }
}

