/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.jsontype.impl;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonProcessingException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.annotate.JsonTypeInfo;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.BeanProperty;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationContext;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.TypeDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeDeserializerBase
extends TypeDeserializer {
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final HashMap<String, JsonDeserializer<Object>> _deserializers;

    protected TypeDeserializerBase(JavaType baseType, TypeIdResolver idRes, BeanProperty property) {
        this._baseType = baseType;
        this._idResolver = idRes;
        this._property = property;
        this._deserializers = new HashMap();
    }

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getClass().getName());
        sb.append("; base-type:").append(this._baseType);
        sb.append("; id-resolver: ").append(this._idResolver);
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext ctxt, String typeId) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> deser;
        HashMap<String, JsonDeserializer<Object>> hashMap = this._deserializers;
        synchronized (hashMap) {
            deser = this._deserializers.get(typeId);
            if (deser == null) {
                JavaType type = this._idResolver.typeFromId(typeId);
                if (type == null) {
                    throw ctxt.unknownTypeException(this._baseType, typeId);
                }
                if (this._baseType != null && this._baseType.getClass() == type.getClass()) {
                    type = this._baseType.narrowBy(type.getRawClass());
                }
                deser = ctxt.getDeserializerProvider().findValueDeserializer(ctxt.getConfig(), type, this._property);
                this._deserializers.put(typeId, deser);
            }
        }
        return deser;
    }
}

