/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum FieldType {
    NULL,
    BOOLEAN,
    BYTE,
    SHORT,
    INTEGER,
    LONG,
    FLOAT,
    DOUBLE,
    STRING,
    DATE,
    BINARY,
    TOKEN_COUNT,
    TEXT,
    KEYWORD,
    HALF_FLOAT,
    SCALED_FLOAT,
    GEO_POINT,
    GEO_SHAPE,
    OBJECT,
    NESTED,
    JOIN,
    IP,
    COMPLETION;

    private static final Set<String> KNOWN_TYPES;
    private static final Map<FieldType, LinkedHashSet<FieldType>> CAST_HIERARCHY;

    public static FieldType parse(String name) {
        if (name == null) {
            return null;
        }
        String n = name.toUpperCase(Locale.ENGLISH);
        return KNOWN_TYPES.contains(n) ? FieldType.valueOf(n) : null;
    }

    public static boolean isRelevant(FieldType fieldType) {
        return fieldType != null && COMPLETION != fieldType;
    }

    public static boolean isCompound(FieldType fieldType) {
        return OBJECT == fieldType || NESTED == fieldType || JOIN == fieldType;
    }

    public static boolean isGeo(FieldType fieldType) {
        return GEO_POINT == fieldType || GEO_SHAPE == fieldType;
    }

    public LinkedHashSet<FieldType> getCastingTypes() {
        LinkedHashSet<FieldType> types = CAST_HIERARCHY.get((Object)this);
        if (types == null) {
            types = new LinkedHashSet();
        }
        return types;
    }

    static {
        KNOWN_TYPES = new LinkedHashSet<String>();
        CAST_HIERARCHY = new HashMap<FieldType, LinkedHashSet<FieldType>>();
        for (FieldType fieldType : EnumSet.allOf(FieldType.class)) {
            KNOWN_TYPES.add(fieldType.name());
        }
        CAST_HIERARCHY.put(NULL, new LinkedHashSet());
        CAST_HIERARCHY.put(BOOLEAN, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(LONG, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(INTEGER, new LinkedHashSet<FieldType>(Arrays.asList(LONG, KEYWORD)));
        CAST_HIERARCHY.put(SHORT, new LinkedHashSet<FieldType>(Arrays.asList(INTEGER, LONG, KEYWORD)));
        CAST_HIERARCHY.put(BYTE, new LinkedHashSet<FieldType>(Arrays.asList(SHORT, INTEGER, LONG, KEYWORD)));
        CAST_HIERARCHY.put(DOUBLE, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(FLOAT, new LinkedHashSet<FieldType>(Arrays.asList(DOUBLE, KEYWORD)));
        CAST_HIERARCHY.put(STRING, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(DATE, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(BINARY, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(TOKEN_COUNT, new LinkedHashSet<FieldType>(Arrays.asList(LONG, KEYWORD)));
        CAST_HIERARCHY.put(TEXT, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(KEYWORD, new LinkedHashSet());
        CAST_HIERARCHY.put(HALF_FLOAT, new LinkedHashSet<FieldType>(Arrays.asList(FLOAT, DOUBLE, KEYWORD)));
        CAST_HIERARCHY.put(SCALED_FLOAT, new LinkedHashSet<FieldType>(Arrays.asList(DOUBLE, KEYWORD)));
        CAST_HIERARCHY.put(GEO_POINT, new LinkedHashSet());
        CAST_HIERARCHY.put(GEO_SHAPE, new LinkedHashSet());
        CAST_HIERARCHY.put(OBJECT, new LinkedHashSet());
        CAST_HIERARCHY.put(NESTED, new LinkedHashSet());
        CAST_HIERARCHY.put(JOIN, new LinkedHashSet());
        CAST_HIERARCHY.put(IP, new LinkedHashSet<FieldType>(Collections.singletonList(KEYWORD)));
        CAST_HIERARCHY.put(COMPLETION, new LinkedHashSet());
    }
}

