/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.util.ObjectUtils;

public abstract class UserProvider
implements SettingsAware {
    protected Settings settings;

    public static UserProvider create(Settings settings) {
        String className = settings.getSecurityUserProviderClass();
        if (className == null) {
            throw new EsHadoopIllegalArgumentException("Could not locate classname for UserProvider. One must be set with es.security.user.provider.class");
        }
        return (UserProvider)ObjectUtils.instantiate(className, settings);
    }

    protected Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isEsKerberosEnabled() {
        return this.settings.getSecurityAuthenticationMethod().equals((Object)AuthenticationMethod.KERBEROS);
    }

    public abstract User getUser();
}

