/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.io.IOException;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.security.EsHadoopSecurityException;
import org.elasticsearch.hadoop.security.KeystoreWrapper;

public class SecureSettings {
    private final Settings settings;
    private KeystoreWrapper keystoreWrapper;

    public SecureSettings(Settings settings) {
        this.settings = settings;
        String keystoreLocation = settings.getProperty("es.keystore.location");
        if (keystoreLocation != null) {
            KeystoreWrapper.KeystoreBuilder builder = KeystoreWrapper.loadStore(keystoreLocation);
            try {
                this.keystoreWrapper = builder.build();
            }
            catch (EsHadoopSecurityException e) {
                throw new EsHadoopException("Could not load keystore", e);
            }
            catch (IOException e) {
                throw new EsHadoopException("Could not load keystore", e);
            }
        } else {
            this.keystoreWrapper = null;
        }
    }

    public String getSecureProperty(String key) {
        String value = null;
        if (this.keystoreWrapper != null) {
            try {
                value = this.keystoreWrapper.getSecureSetting(key);
            }
            catch (EsHadoopSecurityException e) {
                throw new EsHadoopException("Could not read secure setting [" + key + "]", e);
            }
        }
        if (value == null) {
            value = this.settings.getProperty(key);
        }
        return value;
    }
}

