/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading.lingual;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import java.io.IOException;
import java.util.Properties;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsFactory {
    public Tap createTap(Scheme scheme, String path, SinkMode sinkMode, Properties properties) {
        if (!(scheme instanceof EsScheme)) {
            throw new EsHadoopIllegalArgumentException("Unknown scheme; expected " + EsScheme.class.getName());
        }
        String host = properties.getProperty("host");
        String portString = properties.getProperty("port");
        int port = StringUtils.hasText(portString) ? Integer.parseInt(portString) : -1;
        String query = properties.getProperty("query");
        return CascadingUtils.hadoopTap(host, port, path, query, ((EsScheme)scheme).fields, properties);
    }

    public Scheme createScheme(Fields fields, Properties properties) {
        return new EsScheme(fields);
    }

    public static class EsScheme
    extends Scheme {
        Fields fields;

        EsScheme(Fields fields) {
            this.fields = fields;
        }

        public void sourceConfInit(FlowProcess flowProcess, Tap tap, Object conf) {
            throw new UnsupportedOperationException();
        }

        public void sinkConfInit(FlowProcess flowProcess, Tap tap, Object conf) {
            throw new UnsupportedOperationException();
        }

        public boolean source(FlowProcess flowProcess, SourceCall sourceCall) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sink(FlowProcess flowProcess, SinkCall sinkCall) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

