/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;

public enum GeoShapeType implements GeoField
{
    POINT(FieldType.DOUBLE, 1),
    LINE_STRING(FieldType.DOUBLE, 2),
    POLYGON(FieldType.DOUBLE, 3),
    MULTI_POINT(FieldType.DOUBLE, 2),
    MULTI_LINE_STRING(FieldType.DOUBLE, 3),
    MULTI_POLYGON(FieldType.DOUBLE, 4),
    GEOMETRY_COLLECTION(FieldType.OBJECT, 0),
    ENVELOPE(FieldType.DOUBLE, 2),
    CIRCLE(FieldType.DOUBLE, 1);

    private final FieldType format;
    private final int arrayDepth;
    private static final Map<String, GeoShapeType> KNOWN_TYPES;

    public static GeoShapeType parse(String name) {
        if (name == null) {
            return null;
        }
        return KNOWN_TYPES.get(name.toLowerCase(Locale.ENGLISH));
    }

    private GeoShapeType(FieldType format, int arrayDepth) {
        this.format = format;
        this.arrayDepth = arrayDepth;
    }

    @Override
    public FieldType rawType() {
        return this.format;
    }

    @Override
    public int arrayDepth() {
        return this.arrayDepth;
    }

    static {
        KNOWN_TYPES = new LinkedHashMap<String, GeoShapeType>();
        for (GeoShapeType geoShapeType : EnumSet.allOf(GeoShapeType.class)) {
            KNOWN_TYPES.put(geoShapeType.name().toLowerCase(Locale.ENGLISH).replace("_", ""), geoShapeType);
        }
    }
}

