/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.bulk.BulkProcessor;
import org.elasticsearch.hadoop.rest.bulk.BulkResponse;
import org.elasticsearch.hadoop.rest.query.QueryUtils;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.ScrollReaderConfigBuilder;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommands;
import org.elasticsearch.hadoop.serialization.bulk.BulkEntryWriter;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.dto.NodeInfo;
import org.elasticsearch.hadoop.serialization.dto.ShardInfo;
import org.elasticsearch.hadoop.serialization.dto.mapping.FieldParser;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingSet;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.handler.read.impl.AbortOnlyHandlerLoader;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestRepository
implements Closeable,
StatsAware {
    private static Log log = LogFactory.getLog(RestRepository.class);
    private BytesRef trivialBytesRef;
    private boolean writeInitialized = false;
    private RestClient client;
    private MetadataExtractor metaExtractor;
    private BulkEntryWriter bulkEntryWriter;
    private BulkProcessor bulkProcessor;
    private final Settings settings;
    private Resources resources;
    private final Stats stats = new Stats();

    public RestRepository(Settings settings) {
        this.settings = settings;
        this.resources = new Resources(settings);
        Assert.isTrue(this.resources.getResourceRead() != null || this.resources.getResourceWrite() != null, "Invalid configuration - No read or write resource specified");
        this.client = new RestClient(settings);
    }

    private void lazyInitWriting() {
        if (!this.writeInitialized) {
            this.writeInitialized = true;
            this.bulkProcessor = new BulkProcessor(this.client, this.resources.getResourceWrite(), this.settings);
            this.trivialBytesRef = new BytesRef();
            this.bulkEntryWriter = new BulkEntryWriter(this.settings, BulkCommands.create(this.settings, this.metaExtractor, this.client.clusterInfo.getMajorVersion()));
        }
    }

    ScrollQuery scanAll(String query, BytesArray body, ScrollReader reader) {
        return this.scanLimit(query, body, -1L, reader);
    }

    ScrollQuery scanLimit(String query, BytesArray body, long limit, ScrollReader reader) {
        return new ScrollQuery(this, query, body, limit, reader);
    }

    public void addRuntimeFieldExtractor(MetadataExtractor metaExtractor) {
        this.metaExtractor = metaExtractor;
    }

    public void writeToIndex(Object object) {
        Assert.notNull(object, "no object data given");
        this.lazyInitWriting();
        BytesRef serialized = this.bulkEntryWriter.writeBulkEntry(object);
        if (serialized != null) {
            this.doWriteToIndex(serialized);
        }
    }

    public void writeProcessedToIndex(BytesArray ba) {
        Assert.notNull(ba, "no data given");
        Assert.isTrue(ba.length() > 0, "no data given");
        this.lazyInitWriting();
        this.trivialBytesRef.reset();
        this.trivialBytesRef.add(ba);
        this.doWriteToIndex(this.trivialBytesRef);
    }

    private void doWriteToIndex(BytesRef payload) {
        this.bulkProcessor.add(payload);
        payload.reset();
    }

    public BulkResponse tryFlush() {
        Assert.isTrue(this.writeInitialized, "Cannot flush non-initialized write operation");
        return this.bulkProcessor.tryFlush();
    }

    public void flush() {
        Assert.isTrue(this.writeInitialized, "Cannot flush non-initialized write operation");
        this.bulkProcessor.flush();
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing repository and connection to Elasticsearch ...");
        }
        if (this.client == null) {
            return;
        }
        try {
            if (this.bulkProcessor != null) {
                this.bulkProcessor.close();
                this.stats.aggregate(this.bulkProcessor.stats());
                this.bulkProcessor = null;
            }
            if (this.bulkEntryWriter != null) {
                this.bulkEntryWriter.close();
                this.bulkEntryWriter = null;
            }
        }
        finally {
            this.client.close();
            this.stats.aggregate(this.client.stats());
            this.client = null;
        }
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public List<List<Map<String, Object>>> getReadTargetShards() {
        for (int retries = 0; retries < 3; ++retries) {
            List<List<Map<String, Object>>> result = this.doGetReadTargetShards();
            if (result == null) continue;
            return result;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected List<List<Map<String, Object>>> doGetReadTargetShards() {
        return this.client.targetShards(this.resources.getResourceRead().index(), SettingsUtils.getFixedRouting(this.settings));
    }

    public Map<ShardInfo, NodeInfo> getWriteTargetPrimaryShards(boolean clientNodesOnly) {
        for (int retries = 0; retries < 3; ++retries) {
            Map<ShardInfo, NodeInfo> map = this.doGetWriteTargetPrimaryShards(clientNodesOnly);
            if (map == null) continue;
            return map;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected Map<ShardInfo, NodeInfo> doGetWriteTargetPrimaryShards(boolean clientNodesOnly) {
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resources.getResourceWrite().index(), SettingsUtils.getFixedRouting(this.settings));
        LinkedHashMap<ShardInfo, NodeInfo> shards = new LinkedHashMap<ShardInfo, NodeInfo>();
        List<NodeInfo> nodes = this.client.getHttpNodes(clientNodesOnly);
        HashMap<String, NodeInfo> nodeMap = new HashMap<String, NodeInfo>(nodes.size());
        for (NodeInfo nodeInfo : nodes) {
            nodeMap.put(nodeInfo.getId(), nodeInfo);
        }
        block1: for (List list : info) {
            for (Map shardData : list) {
                ShardInfo shard = new ShardInfo(shardData);
                if (!shard.isPrimary()) continue;
                NodeInfo node = (NodeInfo)nodeMap.get(shard.getNode());
                if (node == null) {
                    log.warn((Object)String.format("Cannot find node with id [%s] (is HTTP enabled?) from shard [%s] in nodes [%s]; layout [%s]", shard.getNode(), shard, nodes, info));
                    return null;
                }
                shards.put(shard, node);
                continue block1;
            }
        }
        return shards;
    }

    public MappingSet getMappings() {
        return FieldParser.parseMapping(this.client.getMapping(this.resources.getResourceRead().mapping()));
    }

    public Map<String, GeoField> sampleGeoFields(Mapping mapping) {
        Map<String, GeoField.GeoType> fields = MappingUtils.geoFields(mapping);
        Map<String, Object> geoMapping = this.client.sampleForFields(this.resources.getResourceRead().index(), this.resources.getResourceRead().type(), fields.keySet());
        LinkedHashMap<String, GeoField> geoInfo = new LinkedHashMap<String, GeoField>();
        for (Map.Entry<String, GeoField.GeoType> geoEntry : fields.entrySet()) {
            String fieldName = geoEntry.getKey();
            geoInfo.put(fieldName, MappingUtils.parseGeoInfo(geoEntry.getValue(), geoMapping.get(fieldName)));
        }
        return geoInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollReader.Scroll scroll(String query, BytesArray body, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.execute(Request.Method.POST, query, body).body();
        try {
            ScrollReader.Scroll scroll2 = reader.read(scroll);
            return scroll2;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollReader.Scroll scroll(String scrollId, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.scroll(scrollId);
        try {
            ScrollReader.Scroll scroll2 = reader.read(scroll);
            return scroll2;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    public boolean indexExists(boolean read) {
        Resource res = read ? this.resources.getResourceRead() : this.resources.getResourceWrite();
        boolean exists = this.client.indexExists(res.index());
        if (exists && StringUtils.hasText(res.type())) {
            exists = this.client.typeExists(res.index(), res.type());
        }
        if (!exists && read) {
            try {
                exists = !this.client.getMapping(res.mapping()).isEmpty();
            }
            catch (EsHadoopInvalidRequest ex) {
                exists = false;
            }
        }
        return exists;
    }

    private boolean isReadIndexConcrete() {
        String index = this.resources.getResourceRead().index();
        return !index.contains(",") && !index.contains("*") && !this.client.isAlias(this.resources.getResourceRead().aliases());
    }

    public void putMapping(BytesArray mapping) {
        this.client.putMapping(this.resources.getResourceWrite().index(), this.resources.getResourceWrite().mapping(), mapping.bytes());
    }

    public boolean touch() {
        return this.client.touch(this.resources.getResourceWrite().index());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.client.clusterInfo.getMajorVersion().on(EsMajorVersion.V_1_X)) {
            this.client.delete(this.resources.getResourceWrite().index() + "/" + this.resources.getResourceWrite().type());
        } else {
            try {
                this.client.delete(this.resources.getResourceWrite().index() + "/" + this.resources.getResourceWrite().type() + "/_query?q=*");
            }
            catch (EsHadoopInvalidRequest ehir) {
                log.info((Object)"Skipping delete by query as the plugin is not installed...");
            }
            int batchSize = 500;
            StringBuilder sb = new StringBuilder(this.resources.getResourceWrite().index() + "/" + this.resources.getResourceWrite().type());
            sb.append("/_search?scroll=10m&_source=false&size=");
            sb.append(batchSize);
            if (this.client.clusterInfo.getMajorVersion().onOrAfter(EsMajorVersion.V_5_X)) {
                sb.append("&sort=_doc");
            } else {
                sb.append("&search_type=scan");
            }
            String scanQuery = sb.toString();
            ScrollReader scrollReader = new ScrollReader(ScrollReaderConfigBuilder.builder(new JdkValueReader(), this.settings).setReadMetadata(true).setMetadataName("_metadata").setReturnRawJson(false).setIgnoreUnmappedFields(false).setIncludeFields(Collections.<String>emptyList()).setExcludeFields(Collections.<String>emptyList()).setIncludeArrayFields(Collections.<String>emptyList()).setErrorHandlerLoader(new AbortOnlyHandlerLoader()));
            ScrollQuery sq = this.scanAll(scanQuery, null, scrollReader);
            try {
                BytesArray entry = new BytesArray(0);
                String baseFormat = "{\"delete\":{\"_id\":\"%s\"}}\n";
                String routedFormat = "{\"delete\":{\"_id\":\"%s\", \"_routing\":\"%s\"}}\n";
                boolean hasData = false;
                while (sq.hasNext()) {
                    hasData = true;
                    entry.reset();
                    Object[] kv = sq.next();
                    Map value = (Map)kv[1];
                    Map metadata = (Map)value.get("_metadata");
                    String routing = (String)metadata.get("_routing");
                    String encodedId = StringUtils.jsonEncoding((String)kv[0]);
                    if (StringUtils.hasText(routing)) {
                        String encodedRouting = StringUtils.jsonEncoding(routing);
                        entry.add(StringUtils.toUTF(String.format(routedFormat, encodedId, encodedRouting)));
                    } else {
                        entry.add(StringUtils.toUTF(String.format(baseFormat, encodedId)));
                    }
                    this.writeProcessedToIndex(entry);
                }
                if (hasData) {
                    this.flush();
                    this.client.refresh(this.resources.getResourceWrite());
                }
            }
            finally {
                this.stats.aggregate(sq.stats());
                sq.close();
            }
        }
    }

    public boolean isEmpty(boolean read) {
        Resource res = read ? this.resources.getResourceRead() : this.resources.getResourceWrite();
        boolean exists = this.client.indexExists(res.index());
        return exists ? this.count(read) <= 0L : true;
    }

    public long count(boolean read) {
        Resource res = read ? this.resources.getResourceRead() : this.resources.getResourceWrite();
        return this.client.count(res.index() + "/" + res.type(), QueryUtils.parseQuery(this.settings));
    }

    public boolean waitForYellow() {
        return this.client.waitForHealth(this.resources.getResourceWrite().index(), RestClient.Health.YELLOW, TimeValue.timeValueSeconds(10L));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.client != null) {
            copy.aggregate(this.client.stats());
        }
        if (this.bulkProcessor != null) {
            copy.aggregate(this.bulkProcessor.stats());
        }
        return copy;
    }

    public Settings getSettings() {
        return this.settings;
    }

    private static class Resources {
        private final Settings resourceSettings;
        private Resource resourceRead;
        private Resource resourceWrite;

        public Resources(Settings resourceSettings) {
            this.resourceSettings = resourceSettings;
        }

        public Resource getResourceRead() {
            if (this.resourceRead == null && StringUtils.hasText(this.resourceSettings.getResourceRead())) {
                this.resourceRead = new Resource(this.resourceSettings, true);
            }
            return this.resourceRead;
        }

        public Resource getResourceWrite() {
            if (this.resourceWrite == null && StringUtils.hasText(this.resourceSettings.getResourceWrite())) {
                this.resourceWrite = new Resource(this.resourceSettings, false);
            }
            return this.resourceWrite;
        }
    }
}

