/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopParsingException;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.builder.ValueParsingCallback;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.regex.Regex;

public class ScrollReader {
    private static final Log log = LogFactory.getLog(ScrollReader.class);
    private Parser parser;
    private final ValueReader reader;
    private final ValueParsingCallback parsingCallback;
    private final Map<String, FieldType> esMapping;
    private final boolean trace = log.isTraceEnabled();
    private final boolean readMetadata;
    private final String metadataField;
    private final boolean returnRawJson;
    private final boolean ignoreUnmappedFields;
    private boolean insideGeo = false;
    private final List<FieldFilter.NumberedInclude> includeFields;
    private final List<String> excludeFields;
    private final List<FieldFilter.NumberedInclude> includeArrayFields;
    private static final String[] SCROLL_ID = new String[]{"_scroll_id"};
    private static final String[] HITS = new String[]{"hits"};
    private static final String ID_FIELD = "_id";
    private static final String[] ID = new String[]{"_id"};
    private static final String[] FIELDS = new String[]{"fields"};
    private static final String[] SOURCE = new String[]{"_source"};
    private static final String[] TOTAL = new String[]{"hits", "total"};

    public ScrollReader(ScrollReaderConfig scrollConfig) {
        this.reader = scrollConfig.reader;
        this.parsingCallback = this.reader instanceof ValueParsingCallback ? (ValueParsingCallback)((Object)this.reader) : null;
        this.readMetadata = scrollConfig.readMetadata;
        this.metadataField = scrollConfig.metadataName;
        this.returnRawJson = scrollConfig.returnRawJson;
        this.ignoreUnmappedFields = scrollConfig.ignoreUnmappedFields;
        this.includeFields = FieldFilter.toNumberedFilter(scrollConfig.includeFields);
        this.excludeFields = scrollConfig.excludeFields;
        this.includeArrayFields = FieldFilter.toNumberedFilter(scrollConfig.includeArrayFields);
        Mapping mapping = scrollConfig.resolvedMapping;
        if (mapping != null) {
            if (this.ignoreUnmappedFields) {
                mapping = mapping.filter(scrollConfig.includeFields, scrollConfig.excludeFields);
            }
            this.esMapping = mapping.flatten();
        } else {
            this.esMapping = Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scroll read(InputStream content) throws IOException {
        Assert.notNull(content);
        BytesArray copy = null;
        if (log.isTraceEnabled() || this.returnRawJson) {
            copy = IOUtils.asBytes(content);
            content = new FastByteArrayInputStream(copy);
            log.trace((Object)("About to parse scroll content " + copy));
        }
        this.parser = new JacksonJsonParser(content);
        try {
            Scroll scroll = this.read(copy);
            return scroll;
        }
        finally {
            this.parser.close();
        }
    }

    private Scroll read(BytesArray input) {
        Parser.Token token = ParsingUtils.seek(this.parser, SCROLL_ID);
        Assert.isTrue(token == Parser.Token.VALUE_STRING, "invalid response");
        String scrollId = this.parser.text();
        long totalHits = this.hitsTotal();
        if (totalHits == 0L) {
            return Scroll.empty(scrollId);
        }
        token = ParsingUtils.seek(this.parser, HITS);
        Assert.isTrue(token == Parser.Token.START_ARRAY, "invalid response");
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        token = this.parser.nextToken();
        while (token != Parser.Token.END_ARRAY) {
            results.add(this.readHit());
            token = this.parser.nextToken();
        }
        if (this.returnRawJson) {
            int[] pos = new int[results.size() * 6];
            int offset = 0;
            ArrayList<int[]> fragmentsPos = new ArrayList<int[]>(results.size());
            for (Object[] result : results) {
                int[] asCharPos = ((JsonResult)result[1]).asCharPos();
                fragmentsPos.add(asCharPos);
                System.arraycopy(asCharPos, 0, pos, offset, asCharPos.length);
                offset += asCharPos.length;
            }
            int[] bytesPosition = pos;
            int bytesPositionIndex = 0;
            BytesArray doc = new BytesArray(128);
            for (int fragmentIndex = 0; fragmentIndex < fragmentsPos.size(); ++fragmentIndex) {
                int rangeStart;
                int rangeStop;
                Object[] result = (Object[])results.get(fragmentIndex);
                JsonResult jsonPointers = (JsonResult)result[1];
                int[] fragmentPos = (int[])fragmentsPos.get(fragmentIndex);
                int currentFragmentIndex = 0;
                doc.add(123);
                if (jsonPointers.hasDoc()) {
                    rangeStop = bytesPosition[bytesPositionIndex + 1];
                    rangeStart = bytesPosition[bytesPositionIndex];
                    if (rangeStop - rangeStart < 0) {
                        throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                    }
                    doc.add(input.bytes(), rangeStart, rangeStop - rangeStart);
                    currentFragmentIndex += 2;
                    bytesPositionIndex += 2;
                }
                if (this.readMetadata) {
                    if (jsonPointers.hasDoc()) {
                        doc.add(44);
                    }
                    doc.add(34);
                    doc.add(StringUtils.jsonEncoding(this.metadataField));
                    doc.add(34);
                    doc.add(58);
                    doc.add(123);
                    while (currentFragmentIndex < fragmentPos.length) {
                        rangeStop = bytesPosition[bytesPositionIndex + 1];
                        rangeStart = bytesPosition[bytesPositionIndex];
                        if (rangeStop - rangeStart < 0) {
                            throw new IllegalArgumentException(String.format("Invalid position given=%s %s", rangeStart, rangeStop));
                        }
                        doc.add(input.bytes(), rangeStart, rangeStop - rangeStart);
                        bytesPositionIndex += 2;
                        currentFragmentIndex += 2;
                    }
                    doc.add(125);
                }
                doc.add(125);
                result[1] = this.reader.wrapString(doc.toString());
                doc.reset();
            }
        }
        return new Scroll(scrollId, totalHits, results);
    }

    private Object[] readHit() {
        Parser.Token t = this.parser.currentToken();
        Assert.isTrue(t == Parser.Token.START_OBJECT, "expected object, found " + (Object)((Object)t));
        return this.returnRawJson ? this.readHitAsJson() : this.readHitAsMap();
    }

    private Object[] readHitAsMap() {
        String name;
        Object[] result = new Object[2];
        Object metadata = null;
        Object id = null;
        Parser.Token t = this.parser.currentToken();
        if (this.parsingCallback != null) {
            this.parsingCallback.beginDoc();
        }
        if (this.readMetadata) {
            if (this.parsingCallback != null) {
                this.parsingCallback.beginLeadMetadata();
            }
            result[1] = metadata = this.reader.createMap();
            t = this.parser.nextToken();
            while ((t = this.parser.currentToken()) != null) {
                name = this.parser.currentName();
                String absoluteName = StringUtils.stripFieldNameSourcePrefix(this.parser.absoluteName());
                Object value = null;
                if (t == Parser.Token.FIELD_NAME) {
                    if (!"fields".equals(name) && !"_source".equals(name)) {
                        this.reader.beginField(absoluteName);
                        value = this.read(absoluteName, this.parser.nextToken(), null);
                        if (ID_FIELD.equals(name)) {
                            id = value;
                        }
                        this.reader.addToMap(metadata, this.reader.wrapString(name), value);
                        this.reader.endField(absoluteName);
                        continue;
                    }
                    t = this.parser.nextToken();
                    break;
                }
                t = null;
                break;
            }
            if (this.parsingCallback != null) {
                this.parsingCallback.endLeadMetadata();
            }
            Assert.notNull(id, "no id found");
            result[0] = id;
        } else {
            Assert.notNull((Object)ParsingUtils.seek(this.parser, ID), "no id found");
            result[0] = this.reader.wrapString(this.parser.text());
            t = ParsingUtils.seek(this.parser, SOURCE, FIELDS);
        }
        Object data = Collections.emptyMap();
        if (t != null) {
            if (this.parsingCallback != null) {
                this.parsingCallback.beginSource();
            }
            data = this.read("", t, null);
            if (this.parsingCallback != null) {
                this.parsingCallback.endSource();
            }
            if (this.readMetadata) {
                this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
            }
        } else if (this.readMetadata) {
            if (this.parsingCallback != null) {
                this.parsingCallback.excludeSource();
            }
            data = this.reader.createMap();
            this.reader.addToMap(data, this.reader.wrapString(this.metadataField), metadata);
        }
        result[1] = data;
        if (this.readMetadata && this.parsingCallback != null) {
            this.parsingCallback.beginTrailMetadata();
        }
        while (this.parser.currentToken() == Parser.Token.FIELD_NAME) {
            name = this.parser.currentName();
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(this.parser.absoluteName());
            if (this.readMetadata) {
                if (!"sort".equals(name)) {
                    this.reader.addToMap(data, this.reader.wrapString(name), this.read(absoluteName, this.parser.nextToken(), null));
                    continue;
                }
                this.parser.nextToken();
                this.parser.skipChildren();
                this.parser.nextToken();
                continue;
            }
            this.parser.nextToken();
            this.parser.skipChildren();
            this.parser.nextToken();
        }
        if (this.readMetadata && this.parsingCallback != null) {
            this.parsingCallback.endTrailMetadata();
        }
        if (this.parsingCallback != null) {
            this.parsingCallback.endDoc();
        }
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result));
        }
        return result;
    }

    private boolean shouldSkip(String absoluteName) {
        if (this.insideGeo) {
            return false;
        }
        if (this.ignoreUnmappedFields) {
            return !this.esMapping.containsKey(absoluteName);
        }
        return !FieldFilter.filter((String)absoluteName, this.includeFields, this.excludeFields).matched;
    }

    private Object[] readHitAsJson() {
        Object[] result = new Object[2];
        Object id = null;
        Parser.Token t = this.parser.currentToken();
        JsonResult snippet = new JsonResult();
        if (this.readMetadata) {
            result[1] = snippet;
            t = this.parser.nextToken();
            int metadataStartChar = this.parser.tokenCharOffset();
            int metadataStopChar = -1;
            int endCharOfLastElement = -1;
            while ((t = this.parser.currentToken()) != null) {
                String name = this.parser.currentName();
                String absoluteName = StringUtils.stripFieldNameSourcePrefix(this.parser.absoluteName());
                if (t == Parser.Token.FIELD_NAME) {
                    if (ID_FIELD.equals(name)) {
                        this.reader.beginField(absoluteName);
                        t = this.parser.nextToken();
                        id = this.reader.wrapString(this.parser.text());
                        endCharOfLastElement = this.parser.tokenCharOffset();
                        this.reader.endField(absoluteName);
                        t = this.parser.nextToken();
                        continue;
                    }
                    if ("fields".equals(name) || "_source".equals(name)) {
                        metadataStopChar = endCharOfLastElement;
                        t = this.parser.nextToken();
                        break;
                    }
                    this.parser.skipChildren();
                    this.parser.nextToken();
                    t = this.parser.nextToken();
                    endCharOfLastElement = this.parser.tokenCharOffset();
                    continue;
                }
                metadataStopChar = endCharOfLastElement;
                t = null;
                break;
            }
            Assert.notNull(id, "no id found");
            result[0] = id;
            if (metadataStartChar >= 0 && metadataStopChar >= 0) {
                snippet.addMetadata(new JsonFragment(metadataStartChar, metadataStopChar));
            }
        } else {
            Assert.notNull((Object)ParsingUtils.seek(this.parser, ID), "no id found");
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(this.parser.absoluteName());
            this.reader.beginField(absoluteName);
            result[0] = this.reader.wrapString(this.parser.text());
            this.reader.endField(absoluteName);
            t = ParsingUtils.seek(this.parser, SOURCE, FIELDS);
        }
        if (t != null) {
            t = this.parser.nextToken();
            switch (t) {
                case FIELD_NAME: {
                    int charStart = this.parser.tokenCharOffset();
                    ParsingUtils.skipCurrentBlock(this.parser);
                    int charStop = this.parser.tokenCharOffset();
                    t = this.parser.nextToken();
                    snippet.addDoc(new JsonFragment(charStart, charStop));
                    break;
                }
                case END_OBJECT: {
                    t = this.parser.nextToken();
                    snippet.addDoc(JsonFragment.EMPTY);
                    break;
                }
                default: {
                    throw new EsHadoopIllegalArgumentException("unexpected token in _source: " + (Object)((Object)t));
                }
            }
        }
        int metadataSuffixStartCharPos = this.parser.tokenCharOffset();
        int metadataSuffixStopCharPos = -1;
        while ((t = this.parser.currentToken()) == Parser.Token.FIELD_NAME) {
            t = this.parser.nextToken();
            ParsingUtils.skipCurrentBlock(this.parser);
            t = this.parser.nextToken();
            if (!this.readMetadata) continue;
            metadataSuffixStopCharPos = this.parser.tokenCharOffset();
        }
        if (this.readMetadata && metadataSuffixStartCharPos >= 0 && metadataSuffixStopCharPos >= 0) {
            snippet.addMetadata(new JsonFragment(metadataSuffixStartCharPos, metadataSuffixStopCharPos));
        }
        result[1] = snippet;
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]", result));
        }
        return result;
    }

    private long hitsTotal() {
        ParsingUtils.seek(this.parser, TOTAL);
        long hits = this.parser.longValue();
        return hits;
    }

    protected Object read(String fieldName, Parser.Token t, String fieldMapping) {
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldName, fieldMapping);
        }
        if (t == Parser.Token.START_OBJECT) {
            return this.map(fieldMapping);
        }
        FieldType esType = this.mapping(fieldMapping);
        if (t.isValue()) {
            String rawValue = this.parser.text();
            try {
                if (this.isArrayField(fieldMapping)) {
                    return this.singletonList(fieldMapping, this.parseValue(esType));
                }
                return this.parseValue(esType);
            }
            catch (Exception ex) {
                throw new EsHadoopParsingException(String.format(Locale.ROOT, "Cannot parse value [%s] for field [%s]", rawValue, fieldName), ex);
            }
        }
        return null;
    }

    protected Object readListItem(String fieldName, Parser.Token t, String fieldMapping) {
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldName, fieldMapping);
        }
        if (t == Parser.Token.START_OBJECT) {
            return this.map(fieldMapping);
        }
        FieldType esType = this.mapping(fieldMapping);
        if (t.isValue()) {
            String rawValue = this.parser.text();
            try {
                return this.parseValue(esType);
            }
            catch (Exception ex) {
                throw new EsHadoopParsingException(String.format(Locale.ROOT, "Cannot parse value [%s] for field [%s]", rawValue, fieldName), ex);
            }
        }
        return null;
    }

    private boolean isArrayField(String fieldName) {
        for (FieldFilter.NumberedInclude includeArrayField : this.includeArrayFields) {
            String pattern = includeArrayField.filter;
            if (!Regex.simpleMatch(pattern, fieldName)) continue;
            return true;
        }
        return false;
    }

    private Object parseValue(FieldType esType) {
        Object obj = this.parser.currentToken() == Parser.Token.VALUE_NULL ? null : this.reader.readValue(this.parser, this.parser.text(), esType);
        this.parser.nextToken();
        return obj;
    }

    protected Object list(String fieldName, String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_ARRAY) {
            t = this.parser.nextToken();
        }
        Object array = this.reader.createArray(this.mapping(fieldMapping));
        ArrayList<Object> content = new ArrayList<Object>(1);
        while (this.parser.currentToken() != Parser.Token.END_ARRAY) {
            content.add(this.readListItem(fieldName, this.parser.currentToken(), fieldMapping));
        }
        this.parser.nextToken();
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object singletonList(String fieldMapping, Object value) {
        Object array = this.reader.createArray(this.mapping(fieldMapping));
        ArrayList<Object> content = new ArrayList<Object>(1);
        content.add(value);
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object map(String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_OBJECT) {
            t = this.parser.nextToken();
        }
        boolean toggleGeo = false;
        if (fieldMapping != null && FieldType.isGeo(this.mapping(fieldMapping))) {
            toggleGeo = true;
            this.insideGeo = true;
            if (this.parsingCallback != null) {
                this.parsingCallback.beginGeoField();
            }
        }
        Object map = this.reader.createMap();
        while (this.parser.currentToken() != Parser.Token.END_OBJECT) {
            String currentName = this.parser.currentName();
            String nodeMapping = fieldMapping;
            nodeMapping = nodeMapping != null ? fieldMapping + "." + currentName : currentName;
            String absoluteName = StringUtils.stripFieldNameSourcePrefix(this.parser.absoluteName());
            if (!absoluteName.equals(nodeMapping)) {
                throw new EsHadoopParsingException("Different node mapping " + absoluteName + "|" + nodeMapping);
            }
            if (this.shouldSkip(absoluteName)) {
                Parser.Token nt = this.parser.nextToken();
                if (nt.isValue()) {
                    this.parser.nextToken();
                    continue;
                }
                ParsingUtils.skipCurrentBlock(this.parser);
                this.parser.nextToken();
                continue;
            }
            this.reader.beginField(absoluteName);
            Object fieldName = this.reader.readValue(this.parser, currentName, FieldType.STRING);
            this.reader.addToMap(map, fieldName, this.read(absoluteName, this.parser.nextToken(), nodeMapping));
            this.reader.endField(absoluteName);
        }
        if (toggleGeo) {
            this.insideGeo = false;
            if (this.parsingCallback != null) {
                this.parsingCallback.endGeoField();
            }
        }
        this.parser.nextToken();
        return map;
    }

    private FieldType mapping(String fieldMapping) {
        FieldType esType = this.esMapping.get(fieldMapping);
        if (esType != null) {
            return esType;
        }
        Parser.Token currentToken = this.parser.currentToken();
        if (!currentToken.isValue()) {
            return FieldType.OBJECT;
        }
        block0 : switch (currentToken) {
            case VALUE_NULL: {
                esType = FieldType.NULL;
                break;
            }
            case VALUE_BOOLEAN: {
                esType = FieldType.BOOLEAN;
                break;
            }
            case VALUE_STRING: {
                esType = FieldType.STRING;
                break;
            }
            case VALUE_NUMBER: {
                Parser.NumberType numberType = this.parser.numberType();
                switch (numberType) {
                    case INT: {
                        esType = FieldType.INTEGER;
                        break block0;
                    }
                    case LONG: {
                        esType = FieldType.LONG;
                        break block0;
                    }
                    case FLOAT: {
                        esType = FieldType.FLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        esType = FieldType.DOUBLE;
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        throw new UnsupportedOperationException();
                    }
                    case BIG_INTEGER: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
        }
        return esType;
    }

    public static class ScrollReaderConfig {
        public ValueReader reader;
        public boolean readMetadata;
        public String metadataName;
        public boolean returnRawJson;
        public boolean ignoreUnmappedFields;
        public List<String> includeFields;
        public List<String> excludeFields;
        public List<String> includeArrayFields;
        public Mapping resolvedMapping;

        public ScrollReaderConfig(ValueReader reader, Mapping resolvedMapping, boolean readMetadata, String metadataName, boolean returnRawJson, boolean ignoreUnmappedFields, List<String> includeFields, List<String> excludeFields, List<String> includeArrayFields) {
            this.reader = reader;
            this.readMetadata = readMetadata;
            this.metadataName = metadataName;
            this.returnRawJson = returnRawJson;
            this.ignoreUnmappedFields = ignoreUnmappedFields;
            this.includeFields = includeFields;
            this.excludeFields = excludeFields;
            this.includeArrayFields = includeArrayFields;
            this.resolvedMapping = resolvedMapping;
        }

        public ScrollReaderConfig(ValueReader reader, Mapping resolvedMapping, boolean readMetadata, String metadataName, boolean returnRawJson, boolean ignoreUnmappedFields) {
            this(reader, resolvedMapping, readMetadata, metadataName, returnRawJson, ignoreUnmappedFields, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public ScrollReaderConfig(ValueReader reader) {
            this(false, reader);
        }

        public ScrollReaderConfig(boolean readMetadata, ValueReader reader) {
            this(reader, null, readMetadata, "_metadata", false, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public ScrollReaderConfig(ValueReader reader, Mapping resolvedMapping, Settings cfg) {
            this(reader, resolvedMapping, cfg.getReadMetadata(), cfg.getReadMetadataField(), cfg.getOutputAsJson(), cfg.getReadMappingMissingFieldsIgnore(), StringUtils.tokenize(cfg.getReadFieldInclude()), StringUtils.tokenize(cfg.getReadFieldExclude()), StringUtils.tokenize(cfg.getReadFieldAsArrayInclude()));
        }
    }

    public static class Scroll {
        private final String scrollId;
        private final long total;
        private final List<Object[]> hits;

        static Scroll empty(String scrollId) {
            return new Scroll(scrollId, -1L, Collections.<Object[]>emptyList());
        }

        private Scroll(String scrollId, long total, List<Object[]> hits) {
            this.scrollId = scrollId;
            this.hits = hits;
            this.total = total;
        }

        public String getScrollId() {
            return this.scrollId;
        }

        public long getTotalHits() {
            return this.total;
        }

        public List<Object[]> getHits() {
            return this.hits;
        }
    }

    private static class JsonResult {
        private JsonFragment doc = JsonFragment.EMPTY;
        private final List<JsonFragment> fragments = new ArrayList<JsonFragment>(2);

        private JsonResult() {
        }

        void addMetadata(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.fragments.add(fragment);
            }
        }

        void addDoc(JsonFragment fragment) {
            if (fragment != null && fragment.isValid()) {
                this.doc = fragment;
            }
        }

        boolean hasDoc() {
            return this.doc.isValid();
        }

        int[] asCharPos() {
            int positions = this.fragments.size() << 1;
            if (this.doc.isValid()) {
                positions += 2;
            }
            int[] pos = new int[positions];
            int index = 0;
            if (this.doc.isValid()) {
                pos[index++] = this.doc.charStart;
                pos[index++] = this.doc.charStop;
            }
            for (JsonFragment fragment : this.fragments) {
                pos[index++] = fragment.charStart;
                pos[index++] = fragment.charStop;
            }
            return pos;
        }

        public String toString() {
            return "doc=" + this.doc + "metadata=" + this.fragments;
        }
    }

    private static class JsonFragment {
        static final JsonFragment EMPTY = new JsonFragment(-1, -1){

            @Override
            public String toString() {
                return "Empty";
            }
        };
        final int charStart;
        final int charStop;

        JsonFragment(int charStart, int charStop) {
            this.charStart = charStart;
            this.charStop = charStop;
        }

        boolean isValid() {
            return this.charStart >= 0 && this.charStop >= 0;
        }

        public String toString() {
            return "[" + this.charStart + "," + this.charStop + "]";
        }
    }
}

