/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk.handler.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteErrorHandler;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteFailure;
import org.elasticsearch.hadoop.rest.bulk.handler.DelayableErrorCollector;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;

public class DropAndLog
extends BulkWriteErrorHandler {
    public static final String CONF_LOGGER_NAME = "logger.name";
    public static final String CONF_LOGGER_CLASS = "logger.class";
    public static final String CONF_LOGGER_LEVEL = "logger.level";
    private Log logger;
    private LogLevel loggerLevel;

    @Override
    public void init(Properties properties) {
        Class<?> loggerClass;
        String loggerName = properties.getProperty(CONF_LOGGER_NAME);
        String loggerClassName = properties.getProperty(CONF_LOGGER_CLASS);
        if (loggerClassName != null) {
            try {
                loggerClass = Class.forName(loggerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EsHadoopIllegalArgumentException("Could not locate logger class [" + loggerClassName + "].", cnfe);
            }
        } else {
            loggerClass = null;
        }
        if (loggerName != null && loggerClass != null) {
            throw new EsHadoopIllegalArgumentException("Both logger name and logger class provided for drop and log handler. Provide only one. Bailing out...");
        }
        if (loggerName != null) {
            this.logger = LogFactory.getLog((String)loggerName);
        } else if (loggerClass != null) {
            this.logger = LogFactory.getLog(loggerClass);
        } else {
            throw new EsHadoopIllegalArgumentException("No logger name or logger class provided for drop and log handler. Provide one. Bailing out...");
        }
        String rawLoggerLevel = properties.getProperty(CONF_LOGGER_LEVEL, LogLevel.WARN.name());
        if (!LogLevel.names.contains(rawLoggerLevel)) {
            throw new EsHadoopIllegalArgumentException("Invalid logger level [" + rawLoggerLevel + "] given. Available logging levels: " + LogLevel.names.toString());
        }
        this.loggerLevel = LogLevel.valueOf(rawLoggerLevel);
    }

    @Override
    public HandlerResult onError(BulkWriteFailure entry, DelayableErrorCollector<byte[]> collector) throws Exception {
        switch (this.loggerLevel) {
            case FATAL: {
                if (!this.logger.isFatalEnabled()) break;
                this.logger.fatal((Object)this.renderLogMessage(entry));
                break;
            }
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error((Object)this.renderLogMessage(entry));
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn((Object)this.renderLogMessage(entry));
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info((Object)this.renderLogMessage(entry));
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)this.renderLogMessage(entry));
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace((Object)this.renderLogMessage(entry));
            }
        }
        return HandlerResult.HANDLED;
    }

    private String renderLogMessage(BulkWriteFailure entry) {
        String tailMessage;
        List<String> handlerMessages = entry.previousHandlerMessages();
        if (!handlerMessages.isEmpty()) {
            StringBuilder tail = new StringBuilder("Previous handler messages:");
            for (String handlerMessage : handlerMessages) {
                tail.append("\n\t").append(handlerMessage);
            }
            tailMessage = tail.toString();
        } else {
            tailMessage = "";
        }
        return String.format("Dropping failed bulk entry (response [%s] from server) after [%s] attempts due to error [%s]:%nEntry Contents:%n%s%s", entry.getResponseCode(), entry.getNumberOfAttempts(), entry.getException().getMessage(), ((FastByteArrayInputStream)entry.getEntryContents()).bytes().toString(), tailMessage);
    }

    private static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

        private static Set<String> names;

        static {
            names = new LinkedHashSet<String>();
            for (LogLevel logLevel : LogLevel.values()) {
                names.add(logLevel.name());
            }
        }
    }
}

