/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk.handler;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.hadoop.handler.Exceptional;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;

public class BulkWriteFailure
implements Exceptional {
    private final int response;
    private final Exception reason;
    private final BytesArray contents;
    private final int attemptNumber;
    private final List<String> passReasons;

    public BulkWriteFailure(int response, Exception reason, BytesArray contents, int attemptNumber, List<String> passReasons) {
        this.response = response;
        this.reason = reason;
        this.contents = contents;
        this.attemptNumber = attemptNumber;
        this.passReasons = Collections.unmodifiableList(passReasons);
    }

    public int getResponseCode() {
        return this.response;
    }

    @Override
    public Exception getException() {
        return this.reason;
    }

    @Override
    public List<String> previousHandlerMessages() {
        return this.passReasons;
    }

    public InputStream getEntryContents() {
        return new FastByteArrayInputStream(this.contents);
    }

    public int getNumberOfAttempts() {
        return this.attemptNumber;
    }
}

