/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.cascading.EsLocalScheme;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.SearchRequestBuilder;
import org.elasticsearch.hadoop.rest.query.QueryUtils;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingSet;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.StringUtils;

class EsLocalTap
extends Tap<Properties, ScrollQuery, Object> {
    private static final long serialVersionUID = 8644631529427137615L;
    private static Log log = LogFactory.getLog(EsLocalTap.class);
    private final String target;
    private final Properties tapProperties;

    public EsLocalTap(String host, int port, String resource, String query, Fields fields, Properties props) {
        super((Scheme)new EsLocalScheme(host, port, resource, query, fields, props), SinkMode.UPDATE);
        this.target = resource;
        this.tapProperties = props;
    }

    public String getIdentifier() {
        return this.target;
    }

    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, ScrollQuery input) throws IOException {
        if (input == null) {
            FieldPresenceValidation validation;
            Settings settings = CascadingUtils.addDefaultsToSettings(CascadingUtils.extractOriginalProperties((Properties)flowProcess.getConfigCopy()), this.tapProperties, log);
            RestRepository client = new RestRepository(settings);
            MappingSet mappings = client.getMappings();
            Mapping mapping = mappings.isEmpty() ? null : mappings.getResolvedView();
            Collection<String> fields = CascadingUtils.fieldToAlias(settings, this.getSourceFields());
            String userFilter = settings.getReadSourceFilter();
            if (StringUtils.hasText(userFilter)) {
                if (fields.isEmpty()) {
                    fields = StringUtils.tokenize(userFilter, ",");
                } else {
                    throw new EsHadoopIllegalStateException("User specified source filters were found [" + userFilter + "], " + "but the connector is executing in a state where it has provided its own source filtering " + "[" + StringUtils.concatenate(fields, ",") + "]. Please clear the user specified source fields under the " + "[" + "es.read.source.filter" + "] property to continue.");
                }
            }
            if ((validation = settings.getReadFieldExistanceValidation()).isRequired()) {
                MappingUtils.validateMapping(fields, mapping, validation, log);
            }
            EsMajorVersion esVersion = settings.getInternalVersionOrThrow();
            Resource read = new Resource(settings, true);
            SearchRequestBuilder queryBuilder = new SearchRequestBuilder(esVersion, settings.getReadMetadata() && settings.getReadMetadataVersion()).types(read.type()).indices(read.index()).query(QueryUtils.parseQuery(settings)).scroll(settings.getScrollKeepAlive()).size(settings.getScrollSize()).limit(settings.getScrollLimit()).filters(QueryUtils.parseFilters(settings)).fields(StringUtils.concatenate(fields, ","));
            input = queryBuilder.build(client, new ScrollReader(new ScrollReader.ScrollReaderConfig(new JdkValueReader(), mapping, settings)));
        }
        return new TupleEntrySchemeIterator(flowProcess, this.getScheme(), (Object)input, this.getIdentifier());
    }

    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, Object output) throws IOException {
        return new TupleEntrySchemeCollector(flowProcess, this.getScheme(), output);
    }

    public boolean createResource(Properties conf) throws IOException {
        return false;
    }

    public boolean deleteResource(Properties conf) throws IOException {
        return false;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return -1L;
    }
}

