/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class PartitionDefinition
implements Serializable,
Comparable<PartitionDefinition> {
    private final String index;
    private final int shardId;
    private final Slice slice;
    private final String serializedSettings;
    private final String serializedMapping;
    private final String[] locations;

    public PartitionDefinition(Settings settings, Field mapping, String index, int shardId) {
        this(settings, mapping, index, shardId, null, StringUtils.EMPTY_ARRAY);
    }

    public PartitionDefinition(Settings settings, Field mapping, String index, int shardId, String[] locations) {
        this(settings, mapping, index, shardId, null, locations);
    }

    public PartitionDefinition(Settings settings, Field mapping, String index, int shardId, Slice slice) {
        this(settings, mapping, index, shardId, slice, StringUtils.EMPTY_ARRAY);
    }

    public PartitionDefinition(Settings settings, Field mapping, String index, int shardId, Slice slice, String[] locations) {
        this.index = index;
        this.shardId = shardId;
        this.serializedSettings = settings != null ? settings.save() : null;
        this.serializedMapping = mapping != null ? IOUtils.serializeToBase64(mapping) : null;
        this.slice = slice;
        this.locations = locations;
    }

    public PartitionDefinition(DataInput in) throws IOException {
        byte[] utf;
        int length;
        this.index = in.readUTF();
        this.shardId = in.readInt();
        this.slice = in.readBoolean() ? new Slice(in.readInt(), in.readInt()) : null;
        if (in.readBoolean()) {
            length = in.readInt();
            utf = new byte[length];
            in.readFully(utf);
            this.serializedSettings = StringUtils.asUTFString(utf);
        } else {
            this.serializedSettings = null;
        }
        if (in.readBoolean()) {
            length = in.readInt();
            utf = new byte[length];
            in.readFully(utf);
            this.serializedMapping = StringUtils.asUTFString(utf);
        } else {
            this.serializedMapping = null;
        }
        length = in.readInt();
        this.locations = new String[length];
        for (int i = 0; i < length; ++i) {
            this.locations[i] = in.readUTF();
        }
    }

    public void write(DataOutput out) throws IOException {
        byte[] utf;
        out.writeUTF(this.index);
        out.writeInt(this.shardId);
        out.writeBoolean(this.slice != null);
        if (this.slice != null) {
            out.writeInt(this.slice.id);
            out.writeInt(this.slice.max);
        }
        out.writeBoolean(this.serializedSettings != null);
        if (this.serializedSettings != null) {
            utf = StringUtils.toUTF(this.serializedSettings);
            out.writeInt(utf.length);
            out.write(utf);
        }
        out.writeBoolean(this.serializedMapping != null);
        if (this.serializedMapping != null) {
            utf = StringUtils.toUTF(this.serializedMapping);
            out.writeInt(utf.length);
            out.write(utf);
        }
        out.writeInt(this.locations.length);
        for (String location : this.locations) {
            out.writeUTF(location);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public int getShardId() {
        return this.shardId;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public String getSerializedSettings() {
        return this.serializedSettings;
    }

    public String getSerializedMapping() {
        return this.serializedMapping;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public String[] getHostNames() {
        String[] newLocations = new String[this.locations.length];
        for (int i = 0; i < this.locations.length; ++i) {
            newLocations[i] = StringUtils.parseIpAddress((String)this.locations[i]).ip;
        }
        return newLocations;
    }

    public Settings settings() {
        PropertiesSettings settings = new PropertiesSettings();
        return this.serializedSettings != null ? settings.load(this.serializedSettings) : settings;
    }

    @Override
    public int compareTo(PartitionDefinition o) {
        int cmp = this.index.compareTo(o.index);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.shardId - o.shardId;
        if (cmp != 0) {
            return cmp;
        }
        if (this.slice != null) {
            return this.slice.compareTo(o.slice);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionDefinition that = (PartitionDefinition)o;
        if (this.shardId != that.shardId) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.slice != null ? this.slice.equals(that.slice) : that.slice == null;
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.shardId;
        result = 31 * result + (this.slice != null ? this.slice.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PartitionDefinition{index=" + this.index + ", shardId=" + this.shardId + (this.slice != null ? ", slice=" + this.slice.id + "/" + this.slice.max : "") + ", locations=" + Arrays.toString(this.locations) + '}';
    }

    public static class Slice
    implements Serializable,
    Comparable<Slice> {
        public final int id;
        public final int max;

        public Slice(int id, int max) {
            this.id = id;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Slice slice = (Slice)o;
            if (this.id != slice.id) {
                return false;
            }
            return this.max == slice.max;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.max;
            return result;
        }

        @Override
        public int compareTo(Slice o) {
            int cmp = this.id - o.id;
            if (cmp != 0) {
                return cmp;
            }
            return this.max - o.max;
        }
    }
}

