/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.hadoop.util.regex.Regex;

public abstract class FieldFilter {
    public static final Result INCLUDED = new Result(true);
    public static final Result EXCLUDED = new Result(false);

    public static Result filter(String path, Collection<NumberedInclude> includes, Collection<String> excludes, boolean allowPartialMatches) {
        includes = includes == null ? Collections.emptyList() : includes;
        Collection<Object> collection = excludes = excludes == null ? Collections.emptyList() : excludes;
        if (includes.isEmpty() && excludes.isEmpty()) {
            return INCLUDED;
        }
        if (Regex.simpleMatch(excludes, path)) {
            return EXCLUDED;
        }
        boolean exactIncludeMatch = false;
        boolean pathIsPrefixOfAnInclude = false;
        NumberedInclude matchedInclude = null;
        if (includes.isEmpty()) {
            exactIncludeMatch = true;
        } else {
            Iterator<NumberedInclude> iterator = includes.iterator();
            while (iterator.hasNext()) {
                NumberedInclude filter;
                matchedInclude = filter = iterator.next();
                String include = filter.filter;
                if (include.charAt(0) == '*' && Regex.simpleMatch(include, path)) {
                    exactIncludeMatch = true;
                    break;
                }
                if (include.startsWith(path)) {
                    if (include.length() == path.length()) {
                        exactIncludeMatch = true;
                        break;
                    }
                    if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                        pathIsPrefixOfAnInclude = true;
                        continue;
                    }
                }
                if (!Regex.simpleMatch(include, path)) continue;
                exactIncludeMatch = true;
                break;
            }
        }
        if (exactIncludeMatch || allowPartialMatches && pathIsPrefixOfAnInclude) {
            return matchedInclude != null ? new Result(true, matchedInclude.depth) : INCLUDED;
        }
        return EXCLUDED;
    }

    public static Result filter(String path, Collection<NumberedInclude> includes, Collection<String> excludes) {
        return FieldFilter.filter(path, includes, excludes, true);
    }

    public static List<NumberedInclude> toNumberedFilter(Collection<String> includeAsStrings) {
        if (includeAsStrings == null || includeAsStrings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NumberedInclude> newFilter = new ArrayList<NumberedInclude>(includeAsStrings.size());
        for (String include : includeAsStrings) {
            newFilter.add(new NumberedInclude(include));
        }
        return newFilter;
    }

    public static class NumberedInclude {
        public final String filter;
        public final int depth;

        public NumberedInclude(String filter) {
            this(filter, 1);
        }

        public NumberedInclude(String filter, int depth) {
            this.filter = filter;
            this.depth = depth;
        }
    }

    public static class Result {
        public final boolean matched;
        public final int depth;

        public Result(boolean matched) {
            this(matched, 1);
        }

        public Result(boolean matched, int depth) {
            this.matched = matched;
            this.depth = depth;
        }
    }
}

