/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.BulkResponse;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.query.QueryUtils;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommands;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.dto.NodeInfo;
import org.elasticsearch.hadoop.serialization.dto.ShardInfo;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestRepository
implements Closeable,
StatsAware {
    private static Log log = LogFactory.getLog(RestRepository.class);
    private static final BitSet EMPTY = new BitSet();
    private int bufferEntriesThreshold;
    private final BytesArray ba = new BytesArray(0);
    private final TrackingBytesArray data = new TrackingBytesArray(this.ba);
    private int dataEntries = 0;
    private boolean requiresRefreshAfterBulk = false;
    private boolean executedBulkWrite = false;
    private BytesRef trivialBytesRef;
    private boolean writeInitialized = false;
    private boolean autoFlush = true;
    private boolean hadWriteErrors = false;
    private RestClient client;
    private Resource resourceR;
    private Resource resourceW;
    private BulkCommand command;
    private MetadataExtractor metaExtractor;
    private final Settings settings;
    private final Stats stats = new Stats();

    public RestRepository(Settings settings) {
        this.settings = settings;
        if (StringUtils.hasText(settings.getResourceRead())) {
            this.resourceR = new Resource(settings, true);
        }
        if (StringUtils.hasText(settings.getResourceWrite())) {
            this.resourceW = new Resource(settings, false);
        }
        Assert.isTrue(this.resourceR != null || this.resourceW != null, "Invalid configuration - No read or write resource specified");
        this.client = new RestClient(settings);
    }

    private void lazyInitWriting() {
        if (!this.writeInitialized) {
            this.writeInitialized = true;
            this.autoFlush = !this.settings.getBatchFlushManual();
            this.ba.bytes(new byte[this.settings.getBatchSizeInBytes()], 0);
            this.trivialBytesRef = new BytesRef();
            this.bufferEntriesThreshold = this.settings.getBatchSizeInEntries();
            this.requiresRefreshAfterBulk = this.settings.getBatchRefreshAfterWrite();
            this.command = BulkCommands.create(this.settings, this.metaExtractor, this.client.internalVersion);
        }
    }

    ScrollQuery scanAll(String query, BytesArray body, ScrollReader reader) {
        return this.scanLimit(query, body, -1L, reader);
    }

    ScrollQuery scanLimit(String query, BytesArray body, long limit, ScrollReader reader) {
        return new ScrollQuery(this, query, body, limit, reader);
    }

    public void addRuntimeFieldExtractor(MetadataExtractor metaExtractor) {
        this.metaExtractor = metaExtractor;
    }

    public void writeToIndex(Object object) {
        Assert.notNull(object, "no object data given");
        this.lazyInitWriting();
        this.doWriteToIndex(this.command.write(object));
    }

    public void writeProcessedToIndex(BytesArray ba) {
        Assert.notNull(ba, "no data given");
        Assert.isTrue(ba.length() > 0, "no data given");
        this.lazyInitWriting();
        this.trivialBytesRef.reset();
        this.trivialBytesRef.add(ba);
        this.doWriteToIndex(this.trivialBytesRef);
    }

    private void doWriteToIndex(BytesRef payload) {
        if (payload.length() > this.ba.available()) {
            if (this.autoFlush) {
                this.flush();
            } else {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and bulk buffer full; disable manual flush or increase capacity [current size %s]; bailing out", this.ba.capacity()));
            }
        }
        this.data.copyFrom(payload);
        payload.reset();
        ++this.dataEntries;
        if (this.bufferEntriesThreshold > 0 && this.dataEntries >= this.bufferEntriesThreshold) {
            if (this.autoFlush) {
                this.flush();
            } else if (this.dataEntries > this.bufferEntriesThreshold) {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and maximum number of entries surpassed; disable manual flush or increase capacity [current size %s]; bailing out", this.bufferEntriesThreshold));
            }
        }
    }

    public BulkResponse tryFlush() {
        BulkResponse bulkResult;
        try {
            if (this.data.length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending batch of [%d] bytes/[%s] entries", this.data.length(), this.dataEntries));
                }
                bulkResult = this.client.bulk(this.resourceW, this.data);
                this.executedBulkWrite = true;
            } else {
                bulkResult = BulkResponse.ok(0);
            }
        }
        catch (EsHadoopException ex) {
            this.hadWriteErrors = true;
            throw ex;
        }
        this.discard();
        return bulkResult;
    }

    public void discard() {
        this.data.reset();
        this.dataEntries = 0;
    }

    public void flush() {
        BulkResponse bulk = this.tryFlush();
        if (!bulk.getLeftovers().isEmpty()) {
            String header = String.format("Could not write all entries [%s/%s] (Maybe ES was overloaded?). Error sample (first [%s] error messages):\n", bulk.getLeftovers().cardinality(), bulk.getTotalWrites(), bulk.getErrorExamples().size());
            StringBuilder message = new StringBuilder(header);
            for (String errors : bulk.getErrorExamples()) {
                message.append("\t").append(errors).append("\n");
            }
            message.append("Bailing out...");
            throw new EsHadoopException(message.toString());
        }
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing repository and connection to Elasticsearch ...");
        }
        if (this.client == null) {
            return;
        }
        try {
            if (!this.hadWriteErrors) {
                this.flush();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Dirty close; ignoring last existing write batch...");
            }
            if (this.requiresRefreshAfterBulk && this.executedBulkWrite) {
                this.client.refresh(this.resourceW);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Refreshing index [%s]", this.resourceW));
                }
            }
        }
        finally {
            this.client.close();
            this.stats.aggregate(this.client.stats());
            this.client = null;
        }
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public List<List<Map<String, Object>>> getReadTargetShards() {
        for (int retries = 0; retries < 3; ++retries) {
            List<List<Map<String, Object>>> result = this.doGetReadTargetShards();
            if (result == null) continue;
            return result;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected List<List<Map<String, Object>>> doGetReadTargetShards() {
        return this.client.targetShards(this.resourceR.index(), SettingsUtils.getFixedRouting(this.settings));
    }

    public Map<ShardInfo, NodeInfo> getWriteTargetPrimaryShards(boolean clientNodesOnly) {
        for (int retries = 0; retries < 3; ++retries) {
            Map<ShardInfo, NodeInfo> map = this.doGetWriteTargetPrimaryShards(clientNodesOnly);
            if (map == null) continue;
            return map;
        }
        throw new EsHadoopIllegalStateException("Cluster state volatile; cannot find node backing shards - please check whether your cluster is stable");
    }

    protected Map<ShardInfo, NodeInfo> doGetWriteTargetPrimaryShards(boolean clientNodesOnly) {
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resourceW.index(), SettingsUtils.getFixedRouting(this.settings));
        LinkedHashMap<ShardInfo, NodeInfo> shards = new LinkedHashMap<ShardInfo, NodeInfo>();
        List<NodeInfo> nodes = this.client.getHttpNodes(clientNodesOnly);
        HashMap<String, NodeInfo> nodeMap = new HashMap<String, NodeInfo>(nodes.size());
        for (NodeInfo nodeInfo : nodes) {
            nodeMap.put(nodeInfo.getId(), nodeInfo);
        }
        block1: for (List list : info) {
            for (Map shardData : list) {
                ShardInfo shard = new ShardInfo(shardData);
                if (!shard.isPrimary()) continue;
                NodeInfo node = (NodeInfo)nodeMap.get(shard.getNode());
                if (node == null) {
                    log.warn((Object)String.format("Cannot find node with id [%s] (is HTTP enabled?) from shard [%s] in nodes [%s]; layout [%s]", shard.getNode(), shard, nodes, info));
                    return null;
                }
                shards.put(shard, node);
                continue block1;
            }
        }
        return shards;
    }

    public Field getMapping() {
        return Field.parseField(this.client.getMapping(this.resourceR.mapping()));
    }

    public Map<String, GeoField> sampleGeoFields(Field mapping) {
        Map<String, GeoField.GeoType> fields = MappingUtils.geoFields(mapping);
        Map<String, Object> geoMapping = this.client.sampleForFields(this.resourceR.indexAndType(), fields.keySet());
        LinkedHashMap<String, GeoField> geoInfo = new LinkedHashMap<String, GeoField>();
        for (Map.Entry<String, GeoField.GeoType> geoEntry : fields.entrySet()) {
            String fieldName = geoEntry.getKey();
            geoInfo.put(fieldName, MappingUtils.parseGeoInfo(geoEntry.getValue(), geoMapping.get(fieldName)));
        }
        return geoInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollReader.Scroll scroll(String query, BytesArray body, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.execute(Request.Method.POST, query, body).body();
        try {
            ScrollReader.Scroll scroll2 = reader.read(scroll);
            return scroll2;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollReader.Scroll scroll(String scrollId, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.scroll(scrollId);
        try {
            ScrollReader.Scroll scroll2 = reader.read(scroll);
            return scroll2;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    public boolean indexExists(boolean read) {
        Resource res = read ? this.resourceR : this.resourceW;
        boolean exists = this.client.exists(res.indexAndType());
        if (!exists && read) {
            try {
                exists = !this.client.getMapping(res.mapping()).isEmpty();
            }
            catch (EsHadoopInvalidRequest ex) {
                exists = false;
            }
        }
        return exists;
    }

    private boolean isReadIndexConcrete() {
        String index = this.resourceR.index();
        return !index.contains(",") && !index.contains("*") && !this.client.isAlias(this.resourceR.aliases());
    }

    public void putMapping(BytesArray mapping) {
        this.client.putMapping(this.resourceW.index(), this.resourceW.mapping(), mapping.bytes());
    }

    public boolean touch() {
        return this.client.touch(this.resourceW.index());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.client.internalVersion.on(EsMajorVersion.V_1_X)) {
            this.client.delete(this.resourceW.indexAndType());
        } else {
            try {
                this.client.delete(this.resourceW.indexAndType() + "/_query?q=*");
            }
            catch (EsHadoopInvalidRequest ehir) {
                log.info((Object)"Skipping delete by query as the plugin is not installed...");
            }
            int batchSize = 500;
            StringBuilder sb = new StringBuilder(this.resourceW.indexAndType());
            sb.append("/_search?scroll=10m&_source=false&size=");
            sb.append(batchSize);
            if (this.client.internalVersion.onOrAfter(EsMajorVersion.V_5_X)) {
                sb.append("&sort=_doc");
            } else {
                sb.append("&search_type=scan");
            }
            String scanQuery = sb.toString();
            ScrollReader scrollReader = new ScrollReader(new ScrollReader.ScrollReaderConfig(new JdkValueReader()));
            ScrollQuery sq = this.scanAll(scanQuery, null, scrollReader);
            try {
                BytesArray entry = new BytesArray(0);
                String format = "{\"delete\":{\"_id\":\"%s\"}}\n";
                while (sq.hasNext()) {
                    entry.reset();
                    entry.add(StringUtils.toUTF(String.format(format, sq.next()[0])));
                    this.writeProcessedToIndex(entry);
                }
                this.flush();
                this.client.refresh(this.resourceW);
            }
            finally {
                this.stats.aggregate(sq.stats());
                sq.close();
            }
        }
    }

    public boolean isEmpty(boolean read) {
        Resource res = read ? this.resourceR : this.resourceW;
        boolean exists = this.client.exists(res.indexAndType());
        return exists ? this.count(read) <= 0L : true;
    }

    public long count(boolean read) {
        Resource res = read ? this.resourceR : this.resourceW;
        return this.client.count(res.indexAndType(), QueryUtils.parseQuery(this.settings));
    }

    public boolean waitForYellow() {
        return this.client.waitForHealth(this.resourceW.index(), RestClient.Health.YELLOW, TimeValue.timeValueSeconds(10L));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.client != null) {
            copy.aggregate(this.client.stats());
        }
        return copy;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

