/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoPointType;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoShapeType;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public SchemaUtils.Schema discoverMapping(Settings cfg) {
        Tuple2<Field, Map<String, GeoField>> tuple2 = this.discoverMappingAsField(cfg);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Field field = (Field)tuple2._1();
            Map geoInfo = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)field, (Object)geoInfo);
            Field field2 = (Field)tuple23._1();
            Map geoInfo2 = (Map)tuple23._2();
            StructType struct = this.convertToStruct(field2, geoInfo2, cfg);
            return new SchemaUtils.Schema(field2, struct);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Field, Map<String, GeoField>> discoverMappingAsField(Settings cfg) {
        InitializationUtils.validateSettings(cfg);
        InitializationUtils.discoverEsVersion(cfg, Utils.LOGGER);
        RestRepository repo = new RestRepository(cfg);
        try {
            if (repo.indexExists(true)) {
                Field field = repo.getMapping();
                if (field == null) {
                    throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
                }
                field = MappingUtils.filterMapping(field, cfg);
                Map<String, GeoField> geoInfo = repo.sampleGeoFields(field);
                if (StringUtils.hasText(cfg.getReadFieldInclude()) || StringUtils.hasText(cfg.getReadFieldExclude())) {
                    cfg.setProperty("es.internal.mr.target.fields", StringUtils.concatenate(Field.toLookupMap(field).keySet(), ","));
                }
                return new Tuple2((Object)field, geoInfo);
            }
            throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
        }
        finally {
            repo.close();
        }
    }

    public StructType convertToStruct(Field rootField, Map<String, GeoField> geoInfo, Settings cfg) {
        List<FieldFilter.NumberedInclude> arrayIncludes = SettingsUtils.getFieldArrayFilterInclude(cfg);
        List<String> arrayExcludes = StringUtils.tokenize(cfg.getReadFieldAsArrayExclude());
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])rootField.properties()).map((Function1)new Serializable(geoInfo, cfg, arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final Map geoInfo$2;
            private final Settings cfg$2;
            private final List arrayIncludes$2;
            private final List arrayExcludes$2;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.geoInfo$2, null, this.arrayIncludes$2, this.arrayExcludes$2, this.cfg$2);
            }
            {
                this.geoInfo$2 = geoInfo$2;
                this.cfg$2 = cfg$2;
                this.arrayIncludes$2 = arrayIncludes$2;
                this.arrayExcludes$2 = arrayExcludes$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        if (cfg.getReadMetadata()) {
            StructField metadataMap = DataTypes.createStructField((String)cfg.getReadMetadataField(), (DataType)DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, (boolean)true), (boolean)true);
            fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).$colon$plus((Object)metadataMap, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private StructType convertToStruct(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        return DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])field.properties()).map((Function1)new Serializable(geoInfo, parentName, arrayIncludes, arrayExcludes, cfg){
            public static final long serialVersionUID = 0L;
            private final Map geoInfo$1;
            private final String parentName$1;
            private final List arrayIncludes$1;
            private final List arrayExcludes$1;
            private final Settings cfg$1;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.geoInfo$1, this.parentName$1, this.arrayIncludes$1, this.arrayExcludes$1, this.cfg$1);
            }
            {
                this.geoInfo$1 = geoInfo$1;
                this.parentName$1 = parentName$1;
                this.arrayIncludes$1 = arrayIncludes$1;
                this.arrayExcludes$1 = arrayExcludes$1;
                this.cfg$1 = cfg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructField org$elasticsearch$spark$sql$SchemaUtils$$convertField(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        NullType$ nullType$;
        String absoluteName = parentName == null ? field.name() : new StringBuilder().append((Object)parentName).append((Object)".").append((Object)field.name()).toString();
        FieldFilter.Result matched = FieldFilter.filter(absoluteName, arrayIncludes, arrayExcludes, false);
        boolean createArray = !arrayIncludes.isEmpty() && matched.matched;
        FieldType fieldType = Utils.extractType(field);
        FieldType fieldType2 = FieldType.NULL;
        FieldType fieldType3 = fieldType;
        if (!(fieldType2 != null ? !((Object)((Object)fieldType2)).equals((Object)fieldType3) : fieldType3 != null)) {
            nullType$ = NullType$.MODULE$;
        } else {
            FieldType fieldType4 = FieldType.BINARY;
            FieldType fieldType5 = fieldType;
            if (!(fieldType4 != null ? !((Object)((Object)fieldType4)).equals((Object)fieldType5) : fieldType5 != null)) {
                nullType$ = BinaryType$.MODULE$;
            } else {
                FieldType fieldType6 = FieldType.BOOLEAN;
                FieldType fieldType7 = fieldType;
                if (!(fieldType6 != null ? !((Object)((Object)fieldType6)).equals((Object)fieldType7) : fieldType7 != null)) {
                    nullType$ = BooleanType$.MODULE$;
                } else {
                    FieldType fieldType8 = FieldType.BYTE;
                    FieldType fieldType9 = fieldType;
                    if (!(fieldType8 != null ? !((Object)((Object)fieldType8)).equals((Object)fieldType9) : fieldType9 != null)) {
                        nullType$ = ByteType$.MODULE$;
                    } else {
                        FieldType fieldType10 = FieldType.SHORT;
                        FieldType fieldType11 = fieldType;
                        if (!(fieldType10 != null ? !((Object)((Object)fieldType10)).equals((Object)fieldType11) : fieldType11 != null)) {
                            nullType$ = ShortType$.MODULE$;
                        } else {
                            FieldType fieldType12 = FieldType.INTEGER;
                            FieldType fieldType13 = fieldType;
                            if (!(fieldType12 != null ? !((Object)((Object)fieldType12)).equals((Object)fieldType13) : fieldType13 != null)) {
                                nullType$ = IntegerType$.MODULE$;
                            } else {
                                FieldType fieldType14 = FieldType.LONG;
                                FieldType fieldType15 = fieldType;
                                if (!(fieldType14 != null ? !((Object)((Object)fieldType14)).equals((Object)fieldType15) : fieldType15 != null)) {
                                    nullType$ = LongType$.MODULE$;
                                } else {
                                    FieldType fieldType16 = FieldType.FLOAT;
                                    FieldType fieldType17 = fieldType;
                                    if (!(fieldType16 != null ? !((Object)((Object)fieldType16)).equals((Object)fieldType17) : fieldType17 != null)) {
                                        nullType$ = FloatType$.MODULE$;
                                    } else {
                                        FieldType fieldType18 = FieldType.DOUBLE;
                                        FieldType fieldType19 = fieldType;
                                        if (!(fieldType18 != null ? !((Object)((Object)fieldType18)).equals((Object)fieldType19) : fieldType19 != null)) {
                                            nullType$ = DoubleType$.MODULE$;
                                        } else {
                                            FieldType fieldType20 = FieldType.STRING;
                                            FieldType fieldType21 = fieldType;
                                            if (!(fieldType20 != null ? !((Object)((Object)fieldType20)).equals((Object)fieldType21) : fieldType21 != null)) {
                                                nullType$ = StringType$.MODULE$;
                                            } else {
                                                FieldType fieldType22 = FieldType.TEXT;
                                                FieldType fieldType23 = fieldType;
                                                if (!(fieldType22 != null ? !((Object)((Object)fieldType22)).equals((Object)fieldType23) : fieldType23 != null)) {
                                                    nullType$ = StringType$.MODULE$;
                                                } else {
                                                    FieldType fieldType24 = FieldType.KEYWORD;
                                                    FieldType fieldType25 = fieldType;
                                                    if (!(fieldType24 != null ? !((Object)((Object)fieldType24)).equals((Object)fieldType25) : fieldType25 != null)) {
                                                        nullType$ = StringType$.MODULE$;
                                                    } else {
                                                        FieldType fieldType26 = FieldType.DATE;
                                                        FieldType fieldType27 = fieldType;
                                                        if (!(fieldType26 != null ? !((Object)((Object)fieldType26)).equals((Object)fieldType27) : fieldType27 != null)) {
                                                            nullType$ = cfg.getMappingDateRich() ? TimestampType$.MODULE$ : StringType$.MODULE$;
                                                        } else {
                                                            FieldType fieldType28 = FieldType.OBJECT;
                                                            FieldType fieldType29 = fieldType;
                                                            if (!(fieldType28 != null ? !((Object)((Object)fieldType28)).equals((Object)fieldType29) : fieldType29 != null)) {
                                                                nullType$ = this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg);
                                                            } else {
                                                                FieldType fieldType30 = FieldType.NESTED;
                                                                FieldType fieldType31 = fieldType;
                                                                if (!(fieldType30 != null ? !((Object)((Object)fieldType30)).equals((Object)fieldType31) : fieldType31 != null)) {
                                                                    nullType$ = DataTypes.createArrayType((DataType)this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg));
                                                                } else {
                                                                    FieldType fieldType32 = FieldType.GEO_POINT;
                                                                    FieldType fieldType33 = fieldType;
                                                                    if (!(fieldType32 != null ? !((Object)((Object)fieldType32)).equals((Object)fieldType33) : fieldType33 != null)) {
                                                                        ArrayType arrayType;
                                                                        GeoField geoField = geoInfo.get(absoluteName);
                                                                        GeoPointType geoPointType = GeoPointType.LON_LAT_ARRAY;
                                                                        GeoField geoField2 = geoField;
                                                                        if (!(geoPointType != null ? !geoPointType.equals(geoField2) : geoField2 != null)) {
                                                                            arrayType = DataTypes.createArrayType((DataType)DoubleType$.MODULE$);
                                                                        } else {
                                                                            GeoPointType geoPointType2 = GeoPointType.GEOHASH;
                                                                            GeoField geoField3 = geoField;
                                                                            if (!(geoPointType2 != null ? !geoPointType2.equals(geoField3) : geoField3 != null)) {
                                                                                arrayType = StringType$.MODULE$;
                                                                            } else {
                                                                                GeoPointType geoPointType3 = GeoPointType.LAT_LON_STRING;
                                                                                GeoField geoField4 = geoField;
                                                                                if (!(geoPointType3 != null ? !geoPointType3.equals(geoField4) : geoField4 != null)) {
                                                                                    arrayType = StringType$.MODULE$;
                                                                                } else {
                                                                                    GeoPointType geoPointType4 = GeoPointType.LAT_LON_OBJECT;
                                                                                    GeoField geoField5 = geoField;
                                                                                    if (geoPointType4 != null ? !geoPointType4.equals(geoField5) : geoField5 != null) throw new MatchError((Object)geoField);
                                                                                    StructField lat = DataTypes.createStructField((String)"lat", (DataType)DoubleType$.MODULE$, (boolean)true);
                                                                                    StructField lon = DataTypes.createStructField((String)"lon", (DataType)DoubleType$.MODULE$, (boolean)true);
                                                                                    arrayType = DataTypes.createStructType((StructField[])((StructField[])((Object[])new StructField[]{lat, lon})));
                                                                                }
                                                                            }
                                                                        }
                                                                        ArrayType geoPoint = arrayType;
                                                                        if (Utils.LOGGER.isDebugEnabled()) {
                                                                            Utils.LOGGER.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected field [", "] as a GeoPoint with format ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absoluteName, geoPoint.simpleString()})));
                                                                        }
                                                                        nullType$ = geoPoint;
                                                                    } else {
                                                                        FieldType fieldType34 = FieldType.GEO_SHAPE;
                                                                        FieldType fieldType35 = fieldType;
                                                                        if (!(fieldType34 != null ? !((Object)((Object)fieldType34)).equals((Object)fieldType35) : fieldType35 != null)) {
                                                                            boolean bl;
                                                                            ArrayList<StructField> fields = new ArrayList<StructField>();
                                                                            fields.add(DataTypes.createStructField((String)"type", (DataType)StringType$.MODULE$, (boolean)true));
                                                                            String COORD = "coordinates";
                                                                            GeoField geoField = geoInfo.get(absoluteName);
                                                                            GeoShapeType geoShapeType = GeoShapeType.POINT;
                                                                            GeoField geoField6 = geoField;
                                                                            if (!(geoShapeType != null ? !geoShapeType.equals(geoField6) : geoField6 != null)) {
                                                                                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
                                                                            } else {
                                                                                GeoShapeType geoShapeType2 = GeoShapeType.LINE_STRING;
                                                                                GeoField geoField7 = geoField;
                                                                                if (!(geoShapeType2 != null ? !geoShapeType2.equals(geoField7) : geoField7 != null)) {
                                                                                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                                                                                } else {
                                                                                    GeoShapeType geoShapeType3 = GeoShapeType.POLYGON;
                                                                                    GeoField geoField8 = geoField;
                                                                                    if (!(geoShapeType3 != null ? !geoShapeType3.equals(geoField8) : geoField8 != null)) {
                                                                                        fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
                                                                                        bl = fields.add(DataTypes.createStructField((String)"orientation", (DataType)StringType$.MODULE$, (boolean)true));
                                                                                    } else {
                                                                                        GeoShapeType geoShapeType4 = GeoShapeType.MULTI_POINT;
                                                                                        GeoField geoField9 = geoField;
                                                                                        if (!(geoShapeType4 != null ? !geoShapeType4.equals(geoField9) : geoField9 != null)) {
                                                                                            bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                                                                                        } else {
                                                                                            GeoShapeType geoShapeType5 = GeoShapeType.MULTI_LINE_STRING;
                                                                                            GeoField geoField10 = geoField;
                                                                                            if (!(geoShapeType5 != null ? !geoShapeType5.equals(geoField10) : geoField10 != null)) {
                                                                                                bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
                                                                                            } else {
                                                                                                GeoShapeType geoShapeType6 = GeoShapeType.MULTI_POLYGON;
                                                                                                GeoField geoField11 = geoField;
                                                                                                if (!(geoShapeType6 != null ? !geoShapeType6.equals(geoField11) : geoField11 != null)) {
                                                                                                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 4), (boolean)true));
                                                                                                } else {
                                                                                                    GeoShapeType geoShapeType7 = GeoShapeType.GEOMETRY_COLLECTION;
                                                                                                    GeoField geoField12 = geoField;
                                                                                                    if (!(geoShapeType7 != null ? !geoShapeType7.equals(geoField12) : geoField12 != null)) {
                                                                                                        throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geoshape ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geoInfo})));
                                                                                                    }
                                                                                                    GeoShapeType geoShapeType8 = GeoShapeType.ENVELOPE;
                                                                                                    GeoField geoField13 = geoField;
                                                                                                    if (!(geoShapeType8 != null ? !geoShapeType8.equals(geoField13) : geoField13 != null)) {
                                                                                                        bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                                                                                                    } else {
                                                                                                        GeoShapeType geoShapeType9 = GeoShapeType.CIRCLE;
                                                                                                        GeoField geoField14 = geoField;
                                                                                                        if (geoShapeType9 != null ? !geoShapeType9.equals(geoField14) : geoField14 != null) throw new MatchError((Object)geoField);
                                                                                                        fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
                                                                                                        bl = fields.add(DataTypes.createStructField((String)"radius", (DataType)StringType$.MODULE$, (boolean)true));
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            StructType geoShape = DataTypes.createStructType(fields);
                                                                            if (Utils.LOGGER.isDebugEnabled()) {
                                                                                Utils.LOGGER.debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected field [", "] as a GeoShape with format ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{absoluteName, geoShape.simpleString()})));
                                                                            }
                                                                            nullType$ = geoShape;
                                                                        } else {
                                                                            nullType$ = StringType$.MODULE$;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        NullType$ temp1 = nullType$;
        ObjectRef dataType = new ObjectRef((Object)temp1);
        if (!createArray) return DataTypes.createStructField((String)field.name(), (DataType)((DataType)dataType.elem), (boolean)true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), matched.depth).foreach$mVc$sp((Function1)new Serializable(dataType){
            public static final long serialVersionUID = 0L;
            private final ObjectRef dataType$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.dataType$1.elem = DataTypes.createArrayType((DataType)((DataType)this.dataType$1.elem));
            }
            {
                this.dataType$1 = dataType$1;
            }
        });
        return DataTypes.createStructField((String)field.name(), (DataType)((DataType)dataType.elem), (boolean)true);
    }

    private DataType createNestedArray(DataType elementType, int depth) {
        ObjectRef array = new ObjectRef((Object)elementType);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), depth).foreach$mVc$sp((Function1)new Serializable(array){
            public static final long serialVersionUID = 0L;
            private final ObjectRef array$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.array$1.elem = DataTypes.createArrayType((DataType)((DataType)this.array$1.elem));
            }
            {
                this.array$1 = array$1;
            }
        });
        return (DataType)array.elem;
    }

    public void setRowInfo(Settings settings, StructType struct) {
        Tuple2<Properties, Properties> rowInfo = this.detectRowInfo(settings, struct);
        settings.setProperty(Utils.ROW_INFO_ORDER_PROPERTY, IOUtils.propsToString((Properties)rowInfo._1()));
        settings.setProperty(Utils.ROW_INFO_ARRAY_PROPERTY, IOUtils.propsToString((Properties)rowInfo._2()));
    }

    public Tuple2<LinkedHashMap<String, Seq<String>>, LinkedHashSet<String>> getRowInfo(Settings settings) {
        String rowOrderString = settings.getProperty(Utils.ROW_INFO_ORDER_PROPERTY);
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        String rowArrayString = settings.getProperty(Utils.ROW_INFO_ARRAY_PROPERTY);
        Properties rowArrayProps = StringUtils.hasText(rowArrayString) ? IOUtils.propsFromString(rowArrayString) : new Properties();
        LinkedHashMap order = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final LinkedHashMap order$1;

            public final Object apply(Tuple2<String, String> prop) {
                Buffer value = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala();
                return value.isEmpty() ? BoxedUnit.UNIT : this.order$1.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)value));
            }
            {
                this.order$1 = order$1;
            }
        });
        LinkedHashSet needToBeArray = new LinkedHashSet();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowArrayProps).asScala()).foreach((Function1)new Serializable(needToBeArray){
            public static final long serialVersionUID = 0L;
            private final LinkedHashSet needToBeArray$1;

            public final boolean apply(Tuple2<String, String> prop) {
                return this.needToBeArray$1.add(prop._1());
            }
            {
                this.needToBeArray$1 = needToBeArray$1;
            }
        });
        return new Tuple2((Object)order, needToBeArray);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Properties, Properties> detectRowInfo(Settings settings, StructType struct) {
        void var3_3;
        Tuple2 rowInfo = new Tuple2((Object)new Properties(), (Object)new Properties());
        this.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)rowInfo, Utils.ROOT_LEVEL_NAME, (DataType)struct);
        String csv = SettingsUtils.determineSourceFields(settings);
        Object object = StringUtils.hasText(csv) ? (settings.getReadMetadata() ? ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, new StringBuilder().append((Object)csv).append((Object)",").append((Object)settings.getReadMetadataField()).toString()) : ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, csv)) : BoxedUnit.UNIT;
        return var3_3;
    }

    public void org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo(Tuple2<Properties, Properties> info, String level, DataType dataType) {
        block2: {
            while (true) {
                DataType dataType2;
                if ((dataType2 = dataType) instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    ArrayList fields = new ArrayList();
                    structType.foreach((Function1)new Serializable(info, level, fields){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 info$1;
                        private final String level$1;
                        private final ArrayList fields$1;

                        public final void apply(StructField field) {
                            this.fields$1.add(field.name());
                            String string = this.level$1;
                            String string2 = Utils.ROOT_LEVEL_NAME;
                            SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)this.info$1, !(string != null ? !string.equals(string2) : string2 != null) ? field.name() : new StringBuilder().append((Object)this.level$1).append((Object)".").append((Object)field.name()).toString(), field.dataType());
                        }
                        {
                            this.info$1 = info$1;
                            this.level$1 = level$1;
                            this.fields$1 = fields$1;
                        }
                    });
                    ((Properties)info._1()).setProperty(level, StringUtils.concatenate(fields, ","));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(dataType2 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType2;
                String prop = ((Properties)info._2()).getProperty(level);
                int depth = (StringUtils.hasText(prop) ? Integer.parseInt(prop) : 0) + 1;
                ((Properties)info._2()).setProperty(level, String.valueOf(depth));
                dataType = arrayType.elementType();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

