/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.cascading.EsTap;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.Counter;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.StringUtils;

class EsLocalScheme
extends Scheme<Properties, ScrollQuery, Object, Object[], Object[]> {
    private static final long serialVersionUID = 979036202776892844L;
    private final String resource;
    private final String query;
    private final String host;
    private final int port;
    private final Properties props;
    private transient RestRepository client;

    EsLocalScheme(String host, int port, String index, String query, Fields fields, Properties props) {
        this.resource = index;
        this.query = query;
        this.host = host;
        this.port = port;
        if (fields != null) {
            this.setSinkFields(fields);
            this.setSourceFields(fields);
        }
        this.props = props;
    }

    public void sourcePrepare(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        super.sourcePrepare(flowProcess, sourceCall);
        Object[] context = new Object[1];
        Settings settings = HadoopSettingsManager.loadFrom(flowProcess.getConfigCopy()).merge(this.props);
        context[0] = CascadingUtils.alias(settings);
        sourceCall.setContext((Object)context);
    }

    public void sourceCleanup(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        this.report(((ScrollQuery)sourceCall.getInput()).stats(), flowProcess);
        this.report(((ScrollQuery)sourceCall.getInput()).repository().stats(), flowProcess);
        ((ScrollQuery)sourceCall.getInput()).close();
        sourceCall.setContext(null);
        this.cleanupClient(flowProcess);
    }

    public void sinkCleanup(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        this.cleanupClient(flowProcess);
    }

    private void cleanupClient(FlowProcess<Properties> flowProcess) throws IOException {
        if (this.client != null) {
            this.client.close();
            this.report(this.client.stats(), flowProcess);
            this.client = null;
        }
    }

    private void report(Stats stats, FlowProcess<Properties> flowProcess) {
        for (Counter count : Counter.ALL) {
            flowProcess.increment((Enum)count, count.get(stats));
        }
    }

    public void sinkPrepare(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        super.sinkPrepare(flowProcess, sinkCall);
        Object[] context = new Object[1];
        Settings settings = HadoopSettingsManager.loadFrom(flowProcess.getConfigCopy()).merge(this.props);
        context[0] = CascadingUtils.fieldToAlias(settings, this.getSinkFields());
        sinkCall.setContext((Object)context);
    }

    public void sourceConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, ScrollQuery, Object> tap, Properties conf) {
        this.initClient(conf, true);
    }

    public void sinkConfInit(FlowProcess<Properties> flowProcess, Tap<Properties, ScrollQuery, Object> tap, Properties conf) {
        this.initClient(conf, false);
        InitializationUtils.checkIndexExistence(this.client);
    }

    private void initClient(Properties props, boolean read) {
        if (this.client == null) {
            Settings settings = CascadingUtils.addDefaultsToSettings(props, this.props, LogFactory.getLog(EsTap.class));
            CascadingUtils.init(settings, this.host, this.port, this.resource, this.query, read);
            CascadingUtils.initialDiscovery(settings, LogFactory.getLog(EsTap.class));
            this.client = new RestRepository(settings);
        }
    }

    public boolean source(FlowProcess<Properties> flowProcess, SourceCall<Object[], ScrollQuery> sourceCall) throws IOException {
        ScrollQuery query = (ScrollQuery)sourceCall.getInput();
        if (!query.hasNext()) {
            return false;
        }
        TupleEntry entry = sourceCall.getIncomingEntry();
        Map data = (Map)query.next()[1];
        FieldAlias alias = (FieldAlias)((Object[])sourceCall.getContext())[0];
        if (entry.getFields().isDefined()) {
            for (Comparable field : entry.getFields()) {
                String level;
                Map result = data;
                Iterator<String> iterator = StringUtils.tokenize(alias.toES(field.toString()), ".").iterator();
                while (iterator.hasNext() && (result = result.get(level = iterator.next())) != null) {
                }
                entry.setObject(field, (Object)result);
            }
        } else {
            List elements = Tuple.elements((Tuple)entry.getTuple());
            elements.clear();
            elements.addAll(data.values());
        }
        return true;
    }

    public void sink(FlowProcess<Properties> flowProcess, SinkCall<Object[], Object> sinkCall) throws IOException {
        this.client.writeToIndex(sinkCall);
    }
}

