/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.query.BoolQueryBuilder;
import org.elasticsearch.hadoop.rest.query.FilteredQueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class SearchRequestBuilder {
    private final EsMajorVersion version;
    private final boolean includeVersion;
    private TimeValue scroll = TimeValue.timeValueMinutes(10L);
    private long size = 50L;
    private long limit = -1L;
    private String indices;
    private String types;
    private String shard;
    private String fields;
    private QueryBuilder query;
    private final List<QueryBuilder> filters = new ArrayList<QueryBuilder>();
    private String routing;
    private Slice slice;
    private boolean local = false;

    public SearchRequestBuilder(EsMajorVersion version, boolean includeVersion) {
        this.version = version;
        this.includeVersion = includeVersion;
    }

    public String routing() {
        return this.routing;
    }

    public List<QueryBuilder> filters() {
        return this.filters;
    }

    public SearchRequestBuilder indices(String indices) {
        this.indices = indices;
        return this;
    }

    public SearchRequestBuilder types(String types) {
        this.types = types;
        return this;
    }

    public SearchRequestBuilder query(QueryBuilder builder) {
        this.query = builder;
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public SearchRequestBuilder size(long size) {
        this.size = size;
        return this;
    }

    public SearchRequestBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public SearchRequestBuilder scroll(long keepAliveMillis) {
        Assert.isTrue(keepAliveMillis > 0L, "Invalid scroll");
        this.scroll = TimeValue.timeValueMillis(keepAliveMillis);
        return this;
    }

    public SearchRequestBuilder shard(String shard) {
        Assert.hasText(shard, "Invalid shard");
        this.shard = shard;
        return this;
    }

    public SearchRequestBuilder fields(String fieldsCSV) {
        this.fields = fieldsCSV;
        return this;
    }

    public SearchRequestBuilder filter(QueryBuilder filter) {
        this.filters.add(filter);
        return this;
    }

    public SearchRequestBuilder filters(Collection<QueryBuilder> filters) {
        this.filters.addAll(filters);
        return this;
    }

    public SearchRequestBuilder routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequestBuilder slice(int id, int max) {
        this.slice = new Slice(id, max);
        return this;
    }

    public SearchRequestBuilder local(boolean value) {
        this.local = value;
        return this;
    }

    private String assemble() {
        if (this.limit > 0L && this.size > this.limit) {
            this.size = this.limit;
        }
        LinkedHashMap<String, String> uriParams = new LinkedHashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.encodePath(this.indices));
        if (StringUtils.hasLength(this.types)) {
            sb.append("/");
            sb.append(StringUtils.encodePath(this.types));
        }
        sb.append("/_search?");
        if (this.version.onOrAfter(EsMajorVersion.V_5_X)) {
            uriParams.put("sort", "_doc");
        } else {
            uriParams.put("search_type", "scan");
        }
        uriParams.put("scroll", String.valueOf(this.scroll.toString()));
        uriParams.put("size", String.valueOf(this.size));
        if (this.includeVersion) {
            uriParams.put("version", "");
        }
        if (StringUtils.hasText(this.fields)) {
            uriParams.put("_source", StringUtils.concatenateAndUriEncode(StringUtils.tokenize(this.fields), ","));
        }
        StringBuilder pref = new StringBuilder();
        if (StringUtils.hasText(this.shard)) {
            pref.append("_shards:");
            pref.append(this.shard);
        }
        if (this.local) {
            if (pref.length() > 0) {
                pref.append("|");
            }
            pref.append("_local");
        }
        if (pref.length() > 0) {
            uriParams.put("preference", pref.toString());
        }
        if (this.routing != null) {
            uriParams.put("routing", StringUtils.encodeQuery(this.routing));
        }
        Iterator it = uriParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append((String)entry.getKey());
            if (StringUtils.hasText((CharSequence)entry.getValue())) {
                sb.append("=");
                sb.append((String)entry.getValue());
            }
            if (!it.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollQuery build(RestRepository client, ScrollReader reader) {
        String scrollUri = this.assemble();
        QueryBuilder root = this.query;
        if (!this.filters.isEmpty()) {
            root = this.version.onOrAfter(EsMajorVersion.V_2_X) ? new BoolQueryBuilder().must(this.query).filters(this.filters) : new FilteredQueryBuilder().query(this.query).filters(this.filters);
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(256);
        JacksonJsonGenerator generator = new JacksonJsonGenerator(out);
        try {
            generator.writeBeginObject();
            if (this.slice != null && this.slice.max > 1) {
                generator.writeFieldName("slice");
                generator.writeBeginObject();
                generator.writeFieldName("id");
                generator.writeNumber(this.slice.id);
                generator.writeFieldName("max");
                generator.writeNumber(this.slice.max);
                generator.writeEndObject();
            }
            generator.writeFieldName("query");
            generator.writeBeginObject();
            root.toJson(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
        return client.scanLimit(scrollUri, out.bytes(), this.limit, reader);
    }

    public String toString() {
        return "QueryBuilder [" + this.assemble() + "]";
    }

    private static class Slice {
        final int id;
        final int max;

        Slice(int id, int max) {
            this.id = id;
            this.max = max;
        }
    }
}

