/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.pooling;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.commonshttp.CommonsHttpTransport;
import org.elasticsearch.hadoop.rest.stats.Stats;

class TransportPool {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Settings transportSettings;
    private final String hostName;
    private final String jobPoolingKey;
    private final SimpleRequest validationRequest = new SimpleRequest(Request.Method.GET, null, (CharSequence)"", "");
    private final Map<PooledTransport, Long> idle;
    private final Map<PooledTransport, Long> leased;
    private volatile long lastUsed = 0L;

    TransportPool(String jobPoolingKey, String hostName, Settings transportSettings) {
        this.jobPoolingKey = jobPoolingKey;
        this.hostName = hostName;
        this.transportSettings = transportSettings;
        this.leased = new HashMap<PooledTransport, Long>();
        this.idle = new HashMap<PooledTransport, Long>();
    }

    String getJobPoolingKey() {
        return this.jobPoolingKey;
    }

    private PooledTransport create() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new pooled CommonsHttpTransport for host [" + this.hostName + "] belonging to job [" + this.jobPoolingKey + "]"));
        }
        return new PooledCommonsHttpTransport(this.transportSettings, this.hostName);
    }

    private boolean validate(PooledTransport transport) {
        try {
            Response response = transport.execute(this.validationRequest);
            return response.hasSucceeded();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private void release(PooledTransport transport) {
        transport.close();
    }

    synchronized Transport borrowTransport() {
        long now = System.currentTimeMillis();
        for (Map.Entry<PooledTransport, Long> entry : this.idle.entrySet()) {
            PooledTransport transport = entry.getKey();
            if (this.validate(transport)) {
                this.idle.remove(transport);
                this.leased.put(transport, now);
                this.lastUsed = now;
                return new LeasedTransport(transport, this);
            }
            this.idle.remove(transport);
            this.release(transport);
        }
        PooledTransport transport = this.create();
        this.leased.put(transport, now);
        this.lastUsed = now;
        return new LeasedTransport(transport, this);
    }

    private synchronized void returnTransport(Transport returning) {
        PooledTransport unwrapped;
        long now = System.currentTimeMillis();
        if (returning instanceof LeasedTransport) {
            LeasedTransport leasedTransport = (LeasedTransport)returning;
            unwrapped = leasedTransport.delegate;
        } else if (returning instanceof PooledTransport) {
            unwrapped = (PooledTransport)returning;
        } else {
            throw new EsHadoopIllegalStateException("Cannot return a non-poolable Transport to the pool");
        }
        if (!this.leased.containsKey(unwrapped)) {
            throw new EsHadoopIllegalStateException("Cannot return a Transport object to a pool that was not sourced from the pool");
        }
        this.leased.remove(unwrapped);
        this.idle.put(unwrapped, now);
        this.lastUsed = now;
    }

    public long lastUsed() {
        return this.lastUsed;
    }

    public synchronized int leaseCount() {
        return this.leased.size();
    }

    private final class PooledCommonsHttpTransport
    extends CommonsHttpTransport
    implements PooledTransport {
        PooledCommonsHttpTransport(Settings settings, String host) {
            super(settings, host);
        }

        @Override
        public void clean() {
            this.stats = new Stats();
        }
    }

    private static interface PooledTransport
    extends Transport {
        public void clean();
    }

    private final class LeasedTransport
    implements Transport {
        private final PooledTransport delegate;
        private final TransportPool lender;
        private boolean open = true;
        private Stats finalResults;

        LeasedTransport(PooledTransport delegate, TransportPool lender) {
            this.delegate = delegate;
            this.lender = lender;
        }

        @Override
        public Response execute(Request request) throws IOException {
            if (!this.open) {
                throw new EsHadoopIllegalStateException("Calling execute on a closed Transport object");
            }
            return this.delegate.execute(request);
        }

        @Override
        public void close() {
            if (this.open) {
                this.open = false;
                this.finalResults = this.delegate.stats();
                this.delegate.clean();
                this.lender.returnTransport(this.delegate);
            }
        }

        @Override
        public Stats stats() {
            if (!this.open) {
                return this.finalResults;
            }
            return this.delegate.stats();
        }
    }
}

