/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.pooling;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.TransportFactory;
import org.elasticsearch.hadoop.rest.pooling.TransportPool;

class PooledHttpTransportFactory
implements TransportFactory {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConcurrentMap<String, TransportPool> hostPools = new ConcurrentHashMap<String, TransportPool>();
    private final String jobKey;

    PooledHttpTransportFactory(String jobKey) {
        this.jobKey = jobKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport create(Settings settings, String hostInfo) {
        Transport borrowed;
        if (!this.jobKey.equals(settings.getProperty("es.internal.transport.pooling.key"))) {
            throw new EsHadoopIllegalArgumentException("Settings object passed does not have the same `es.internal.transport.pooling.key` property as when this pool was created. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
        TransportPool pool = (TransportPool)this.hostPools.get(hostInfo);
        if (pool == null) {
            PooledHttpTransportFactory pooledHttpTransportFactory = this;
            synchronized (pooledHttpTransportFactory) {
                pool = (TransportPool)this.hostPools.get(hostInfo);
                if (pool == null) {
                    pool = new TransportPool(this.jobKey, hostInfo, settings);
                    this.hostPools.put(hostInfo, pool);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Creating new TransportPool for job [" + this.jobKey + "] for host [" + hostInfo + "]"));
                    }
                }
            }
        }
        if (!pool.getJobPoolingKey().equals(this.jobKey)) {
            throw new EsHadoopIllegalArgumentException("PooledTransportFactory found a pool with a different owner than this job. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
        try {
            borrowed = pool.borrowTransport();
        }
        catch (Exception e) {
            throw new EsHadoopException(String.format("Could not get a Transport from the Transport Pool for host [%s]", hostInfo));
        }
        return borrowed;
    }
}

