/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.List;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

class UpdateBulkFactory
extends AbstractBulkFactory {
    private final int RETRY_ON_FAILURE;
    private final String RETRY_HEADER;
    private final String SCRIPT;
    private final String SCRIPT_LANG;
    private final boolean HAS_SCRIPT;
    private final boolean HAS_LANG;
    private final boolean UPSERT;

    public UpdateBulkFactory(Settings settings, MetadataExtractor metaExtractor) {
        this(settings, false, metaExtractor);
    }

    public UpdateBulkFactory(Settings settings, boolean upsert, MetadataExtractor metaExtractor) {
        super(settings, metaExtractor);
        this.UPSERT = upsert;
        this.RETRY_ON_FAILURE = settings.getUpdateRetryOnConflict();
        this.RETRY_HEADER = "\"_retry_on_conflict\":" + this.RETRY_ON_FAILURE + "";
        this.HAS_SCRIPT = StringUtils.hasText(settings.getUpdateScript());
        this.HAS_LANG = StringUtils.hasText(settings.getUpdateScriptLang());
        this.SCRIPT_LANG = ",\"lang\":\"" + settings.getUpdateScriptLang() + "\"";
        this.SCRIPT = "{\"script\":{\"inline\":\"" + settings.getUpdateScript() + "\"";
    }

    @Override
    protected String getOperation() {
        return "update";
    }

    @Override
    protected void otherHeader(List<Object> list, boolean commaMightBeNeeded) {
        if (this.RETRY_ON_FAILURE > 0) {
            if (commaMightBeNeeded) {
                list.add(",");
            }
            list.add(this.RETRY_HEADER);
        }
    }

    @Override
    protected void writeObjectHeader(List<Object> list) {
        super.writeObjectHeader(list);
        Object paramExtractor = this.getExtractorOrDynamicValue(MetadataExtractor.Metadata.PARAMS, this.getParamExtractor());
        if (this.HAS_SCRIPT) {
            list.add(this.SCRIPT);
            if (this.HAS_LANG) {
                list.add(this.SCRIPT_LANG);
            }
            if (paramExtractor != null) {
                list.add(",\"params\":");
                list.add(paramExtractor);
            }
            list.add("}");
            if (this.UPSERT) {
                list.add(",\"upsert\":");
            }
        } else {
            list.add("{");
            if (this.UPSERT) {
                list.add("\"doc_as_upsert\":true,");
            }
            list.add("\"doc\":");
        }
    }

    @Override
    protected void writeObjectEnd(List<Object> after) {
        after.add("}");
        super.writeObjectEnd(after);
    }

    @Override
    protected boolean id(List<Object> list, boolean commaMightBeNeeded) {
        boolean added = super.id(list, commaMightBeNeeded);
        Assert.isTrue(added, String.format("Operation [%s] requires an id but none was given/found", this.getOperation()));
        return added;
    }
}

