/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.DateUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;

public class JdkValueReader
implements SettingsAware,
ValueReader {
    private boolean emptyAsNull = true;
    private boolean richDate = true;
    protected Collection<FieldFilter.NumberedInclude> arrayInclude = Collections.emptyList();
    protected Collection<String> arrayExclude = Collections.emptyList();
    protected String currentFieldName;
    protected int nestedArrayLevel = 0;

    @Override
    public Object readValue(Parser parser, String value, FieldType esType) {
        if (esType == null) {
            return this.nullValue();
        }
        switch (esType) {
            case NULL: {
                return this.nullValue();
            }
            case STRING: 
            case TEXT: 
            case KEYWORD: {
                return this.textValue(value);
            }
            case BYTE: {
                return this.byteValue(value, parser);
            }
            case SHORT: {
                return this.shortValue(value, parser);
            }
            case INTEGER: {
                return this.intValue(value, parser);
            }
            case TOKEN_COUNT: 
            case LONG: {
                return this.longValue(value, parser);
            }
            case HALF_FLOAT: 
            case FLOAT: {
                return this.floatValue(value, parser);
            }
            case DOUBLE: {
                return this.doubleValue(value, parser);
            }
            case BOOLEAN: {
                return this.booleanValue(value, parser);
            }
            case BINARY: {
                return this.binaryValue(parser.binaryValue());
            }
            case DATE: {
                return this.date(value, parser);
            }
        }
        return this.textValue(value);
    }

    @Override
    public Object createMap() {
        return new LinkedHashMap();
    }

    @Override
    public void addToMap(Object map, Object key, Object value) {
        ((Map)map).put(key, value != null ? value : this.nullValue());
    }

    @Override
    public Object createArray(FieldType type) {
        ++this.nestedArrayLevel;
        return Collections.emptyList();
    }

    @Override
    public Object addToArray(Object array, List<Object> value) {
        --this.nestedArrayLevel;
        array = value;
        if (this.nestedArrayLevel == 0) {
            int actualDepth;
            int extraDepth;
            FieldFilter.Result result = FieldFilter.filter(this.currentFieldName, this.arrayInclude, this.arrayExclude);
            if (result.matched && result.depth > 1 && (extraDepth = result.depth - (actualDepth = this.arrayDepth(value))) > 0) {
                array = this.wrapArray(array, extraDepth);
            }
        }
        return array;
    }

    protected int arrayDepth(Object potentialArray) {
        int depth = 0;
        while (potentialArray instanceof List) {
            ++depth;
            List col = (List)potentialArray;
            if (col.size() <= 0) continue;
            potentialArray = col.get(0);
        }
        return depth;
    }

    protected Object wrapArray(Object array, int extraDepth) {
        for (int i = 0; i < extraDepth; ++i) {
            array = Arrays.asList(array);
        }
        return array;
    }

    @Override
    public Object wrapString(String value) {
        return this.textValue(value);
    }

    @Override
    public void beginField(String fieldName) {
        this.currentFieldName = fieldName;
    }

    @Override
    public void endField(String fieldName) {
        this.currentFieldName = null;
    }

    private boolean isEmpty(String value) {
        return value.length() == 0 && this.emptyAsNull;
    }

    protected Object binaryValue(byte[] value) {
        return value;
    }

    protected Object booleanValue(String value, Parser parser) {
        Boolean val = null;
        if (value == null) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        if (tk == Parser.Token.VALUE_NULL) {
            return this.nullValue();
        }
        val = tk == Parser.Token.VALUE_BOOLEAN ? Boolean.valueOf(parser.booleanValue()) : (tk == Parser.Token.VALUE_NUMBER ? Boolean.valueOf(parser.intValue() != 0) : this.parseBoolean(value));
        return this.processBoolean(val);
    }

    protected Boolean parseBoolean(String value) {
        return Booleans.parseBoolean(value);
    }

    protected Object processBoolean(Boolean value) {
        return value;
    }

    protected Object doubleValue(String value, Parser parser) {
        Double val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Double.valueOf(parser.doubleValue()) : this.parseDouble(value);
        return this.processDouble(val);
    }

    protected Double parseDouble(String value) {
        return Double.parseDouble(value);
    }

    protected Object processDouble(Double value) {
        return value;
    }

    protected Object floatValue(String value, Parser parser) {
        Float val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Float.valueOf(parser.floatValue()) : this.parseFloat(value);
        return this.processFloat(val);
    }

    protected Float parseFloat(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    protected Object processFloat(Float value) {
        return value;
    }

    protected Object longValue(String value, Parser parser) {
        Long val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Long.valueOf(parser.longValue()) : this.parseLong(value);
        return this.processLong(val);
    }

    protected Long parseLong(String value) {
        return Long.parseLong(value);
    }

    protected Object processLong(Long value) {
        return value;
    }

    protected Object intValue(String value, Parser parser) {
        Integer val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Integer.valueOf(parser.intValue()) : this.parseInteger(value);
        return this.processInteger(val);
    }

    protected Integer parseInteger(String value) {
        return Integer.parseInt(value);
    }

    protected Object processInteger(Integer value) {
        return value;
    }

    protected Object byteValue(String value, Parser parser) {
        Byte val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Byte.valueOf((byte)parser.intValue()) : this.parseByte(value);
        return this.processByte(val);
    }

    protected Byte parseByte(String value) {
        return Byte.parseByte(value);
    }

    protected Object processByte(Byte value) {
        return value;
    }

    protected Object shortValue(String value, Parser parser) {
        Short val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? Short.valueOf(parser.shortValue()) : this.parseShort(value);
        return this.processShort(val);
    }

    protected Short parseShort(String value) {
        return Short.parseShort(value);
    }

    protected Object processShort(Short value) {
        return value;
    }

    protected Object textValue(String value) {
        return value != null ? (!StringUtils.hasText(value) && this.emptyAsNull ? this.nullValue() : this.parseString(value)) : this.nullValue();
    }

    protected Object parseString(String value) {
        return value;
    }

    protected Object nullValue() {
        return null;
    }

    protected Object date(String value, Parser parser) {
        Object val = null;
        if (value == null || this.isEmpty(value)) {
            return this.nullValue();
        }
        Parser.Token tk = parser.currentToken();
        val = tk == Parser.Token.VALUE_NUMBER ? this.parseDate(parser.longValue(), this.richDate) : this.parseDate(value, this.richDate);
        return this.processDate(val);
    }

    protected Object parseDate(Long value, boolean richDate) {
        return richDate ? this.createDate(value) : value;
    }

    protected Object parseDate(String value, boolean richDate) {
        return richDate ? this.createDate(DateUtils.parseDate(value).getTimeInMillis()) : this.parseString(value);
    }

    protected Object createDate(long timestamp) {
        return new Date(timestamp);
    }

    protected Object processDate(Object value) {
        return value;
    }

    @Override
    public void setSettings(Settings settings) {
        this.emptyAsNull = settings.getReadFieldEmptyAsNull();
        this.richDate = settings.getMappingDateRich();
        this.arrayInclude = SettingsUtils.getFieldArrayFilterInclude(settings);
        this.arrayExclude = StringUtils.tokenize(settings.getReadFieldAsArrayExclude());
    }
}

