/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class ParsingUtils {
    public static final String NOT_FOUND = "(not found)";

    public static Parser.Token seek(Parser parser, String path) {
        if (!StringUtils.hasText(path)) {
            return null;
        }
        List<String> tokens = StringUtils.tokenize(path, ".");
        return ParsingUtils.seek(parser, tokens.toArray(new String[tokens.size()]));
    }

    public static Parser.Token seek(Parser parser, String[] path1) {
        return ParsingUtils.seek(parser, path1, null);
    }

    public static Parser.Token seek(Parser parser, String[] path1, String[] path2) {
        return ParsingUtils.doSeekToken(parser, path1, 0, path2, 0);
    }

    private static Parser.Token doSeekToken(Parser parser, String[] path1, int index1, String[] path2, int index2) {
        Parser.Token token = null;
        token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        while ((token = parser.nextToken()) != null) {
            if (token == Parser.Token.START_OBJECT) {
                token = parser.nextToken();
            }
            if (token != Parser.Token.FIELD_NAME) break;
            String currentName = parser.currentName();
            if (path1 != null && currentName.equals(path1[index1])) {
                if (index1 + 1 < path1.length) {
                    return ParsingUtils.doSeekToken(parser, path1, index1 + 1, null, 0);
                }
                return parser.nextToken();
            }
            if (path2 != null && currentName.equals(path2[index2])) {
                if (index2 + 1 < path2.length) {
                    return ParsingUtils.doSeekToken(parser, null, 0, path2, index2 + 1);
                }
                return parser.nextToken();
            }
            parser.nextToken();
            parser.skipChildren();
        }
        return null;
    }

    public static List<Object> values(Parser parser, String ... paths) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(paths.length);
        int maxNesting = 0;
        for (String path : paths) {
            Matcher matcher = new Matcher(path);
            matchers.add(matcher);
            if (matcher.nesting() <= maxNesting) continue;
            maxNesting = matcher.nesting();
        }
        ParsingUtils.doFind(parser, matchers, 0, maxNesting);
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Matcher matcher : matchers) {
            matches.add(matcher.matched ? matcher.value : NOT_FOUND);
        }
        return matches;
    }

    private static void doFind(Parser parser, List<Matcher> currentMatchers, int level, int maxNesting) {
        Parser.Token token = parser.currentToken();
        if (token == null) {
            parser.nextToken();
        }
        while ((token = parser.nextToken()) != null && token != Parser.Token.END_OBJECT) {
            if (token != Parser.Token.FIELD_NAME) continue;
            String currentName = parser.currentName();
            Object value = null;
            boolean valueRead = false;
            ArrayList<Matcher> nextLevel = null;
            for (Matcher matcher : currentMatchers) {
                if (!matcher.matches(currentName, level)) continue;
                if (matcher.nesting() == level) {
                    if (!valueRead) {
                        valueRead = true;
                        switch (parser.nextToken()) {
                            case VALUE_NUMBER: {
                                value = parser.numberValue();
                                break;
                            }
                            case VALUE_BOOLEAN: {
                                value = parser.booleanValue();
                                break;
                            }
                            case VALUE_NULL: {
                                value = null;
                                break;
                            }
                            case VALUE_STRING: {
                                value = parser.text();
                                break;
                            }
                            default: {
                                value = ParsingUtils.readValueAsString(parser);
                            }
                        }
                    }
                    matcher.value(value);
                    continue;
                }
                if (nextLevel == null) {
                    nextLevel = new ArrayList<Matcher>(currentMatchers.size());
                }
                nextLevel.add(matcher);
            }
            if (valueRead) continue;
            switch (parser.nextToken()) {
                case START_OBJECT: {
                    if (level < maxNesting && nextLevel != null) {
                        ParsingUtils.doFind(parser, (List<Matcher>)nextLevel, level + 1, maxNesting);
                        break;
                    }
                    parser.skipChildren();
                    break;
                }
                case START_ARRAY: {
                    parser.skipChildren();
                }
            }
        }
    }

    private static String readValueAsString(Parser parser) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(256);
        JacksonJsonGenerator generator = new JacksonJsonGenerator(out);
        ParsingUtils.traverse(parser, generator);
        generator.close();
        return out.toString();
    }

    private static void traverse(Parser parser, Generator generator) {
        Parser.Token t = parser.currentToken();
        switch (t) {
            case START_OBJECT: {
                ParsingUtils.traverseMap(parser, generator);
                break;
            }
            case START_ARRAY: {
                ParsingUtils.traverseArray(parser, generator);
                break;
            }
            case FIELD_NAME: {
                generator.writeFieldName(parser.currentName());
                parser.nextToken();
                ParsingUtils.traverse(parser, generator);
                break;
            }
            case VALUE_STRING: {
                generator.writeString(parser.text());
                parser.nextToken();
                break;
            }
            case VALUE_BOOLEAN: {
                generator.writeBoolean(parser.booleanValue());
                parser.nextToken();
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
                parser.nextToken();
                break;
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: {
                        generator.writeNumber(parser.intValue());
                        break;
                    }
                    case LONG: {
                        generator.writeNumber(parser.longValue());
                        break;
                    }
                    case DOUBLE: {
                        generator.writeNumber(parser.doubleValue());
                        break;
                    }
                    case FLOAT: {
                        generator.writeNumber(parser.floatValue());
                    }
                }
                parser.nextToken();
            }
        }
    }

    private static void traverseMap(Parser parser, Generator generator) {
        generator.writeBeginObject();
        parser.nextToken();
        while (parser.currentToken() != Parser.Token.END_OBJECT) {
            ParsingUtils.traverse(parser, generator);
        }
        generator.writeEndObject();
        parser.nextToken();
    }

    private static void traverseArray(Parser parser, Generator generator) {
        generator.writeBeginArray();
        parser.nextToken();
        while (parser.currentToken() != Parser.Token.END_ARRAY) {
            ParsingUtils.traverse(parser, generator);
        }
        generator.writeEndArray();
        parser.nextToken();
    }

    public static void skipCurrentBlock(Parser parser) {
        int open = 1;
        Parser.Token t;
        while ((t = parser.nextToken()) != null) {
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return;
                }
            }
        }
        return;
    }

    private static class Matcher {
        private final List<String> tokens;
        private final String path;
        private boolean matched = false;
        private Object value;

        Matcher(String path) {
            this.path = path;
            this.tokens = StringUtils.tokenize(path, ".");
        }

        int nesting() {
            return this.tokens.size() - 1;
        }

        boolean matches(String key, int level) {
            if (level < this.tokens.size()) {
                return this.tokens.get(level).equals(key);
            }
            return false;
        }

        void value(Object value) {
            this.matched = true;
            this.value = value;
        }

        public String toString() {
            return this.path;
        }
    }
}

