/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public enum FieldType {
    NULL,
    BOOLEAN,
    BYTE,
    SHORT,
    INTEGER,
    LONG,
    FLOAT,
    DOUBLE,
    STRING,
    DATE,
    BINARY,
    TOKEN_COUNT,
    TEXT,
    KEYWORD,
    GEO_POINT,
    GEO_SHAPE,
    OBJECT,
    NESTED,
    IP,
    COMPLETION;

    private static final Set<String> KNOWN_TYPES;

    public static FieldType parse(String name) {
        if (name == null) {
            return null;
        }
        String n = name.toUpperCase(Locale.ENGLISH);
        return KNOWN_TYPES.contains(n) ? FieldType.valueOf(n) : null;
    }

    public static boolean isRelevant(FieldType fieldType) {
        return fieldType != null && COMPLETION != fieldType;
    }

    public static boolean isCompound(FieldType fieldType) {
        return OBJECT == fieldType || NESTED == fieldType;
    }

    public static boolean isGeo(FieldType fieldType) {
        return GEO_POINT == fieldType || GEO_SHAPE == fieldType;
    }

    static {
        KNOWN_TYPES = new LinkedHashSet<String>();
        for (FieldType fieldType : EnumSet.allOf(FieldType.class)) {
            KNOWN_TYPES.add(fieldType.name());
        }
    }
}

