/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.QueryUtils;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class QueryBuilder {
    private final Resource resource;
    private final Map<String, String> uriParams = new LinkedHashMap<String, String>();
    private BytesArray bodyQuery;
    private TimeValue time = TimeValue.timeValueMinutes(10L);
    private long size = 50L;
    private long limit = -1L;
    private String shard;
    private String node;
    private boolean onlyNode;
    private String[] filters;
    private final boolean IS_ES_50;
    private final boolean INCLUDE_VERSION;
    private String fields;

    QueryBuilder(Settings settings) {
        this.resource = new Resource(settings, true);
        this.IS_ES_50 = SettingsUtils.isEs50(settings);
        this.INCLUDE_VERSION = settings.getReadMetadata() && settings.getReadMetadataVersion();
        this.bodyQuery = QueryUtils.parseQuery(settings);
    }

    public static QueryBuilder query(Settings settings) {
        return new QueryBuilder(settings).time(settings.getScrollKeepAlive()).size(settings.getScrollSize()).limit(settings.getScrollLimit());
    }

    public QueryBuilder size(long size) {
        this.size = size;
        return this;
    }

    public QueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder time(long timeInMillis) {
        Assert.isTrue(timeInMillis > 0L, "Invalid time");
        this.time = TimeValue.timeValueMillis(timeInMillis);
        return this;
    }

    public QueryBuilder node(String node) {
        Assert.hasText(node, "Invalid node");
        this.node = node;
        return this;
    }

    public QueryBuilder shard(String shard) {
        Assert.hasText(shard, "Invalid shard");
        this.shard = shard;
        return this;
    }

    public QueryBuilder fields(String fieldsCSV) {
        this.fields = fieldsCSV;
        return this;
    }

    public QueryBuilder filter(String ... filters) {
        this.filters = filters;
        return this;
    }

    private String assemble() {
        if (this.limit > 0L && this.size > this.limit) {
            this.size = this.limit;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.encodePath(this.resource.index()));
        sb.append("/");
        sb.append(StringUtils.encodePath(this.resource.type()));
        sb.append("/_search?");
        if (this.IS_ES_50) {
            this.uriParams.put("sort", "_doc");
        } else {
            this.uriParams.put("search_type", "scan");
        }
        this.uriParams.put("scroll", String.valueOf(this.time.toString()));
        this.uriParams.put("size", String.valueOf(this.size));
        if (this.INCLUDE_VERSION) {
            this.uriParams.put("version", "");
        }
        if (StringUtils.hasText(this.fields)) {
            this.uriParams.put("_source", StringUtils.concatenateAndUriEncode(StringUtils.tokenize(this.fields), ","));
            this.uriParams.remove("fields");
        } else {
            this.uriParams.remove("fields");
        }
        StringBuilder pref = new StringBuilder();
        if (StringUtils.hasText(this.shard)) {
            pref.append("_shards:");
            pref.append(this.shard);
        }
        if (StringUtils.hasText(this.node)) {
            if (pref.length() > 0) {
                pref.append(";");
            }
            pref.append(this.onlyNode ? "_only_node:" : "_prefer_node:");
            pref.append(this.node);
        }
        if (pref.length() > 0) {
            this.uriParams.put("preference", pref.toString());
        }
        Iterator<Map.Entry<String, String>> it = this.uriParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append(entry.getKey());
            if (StringUtils.hasText(entry.getValue())) {
                sb.append("=");
                sb.append(entry.getValue());
            }
            if (!it.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public ScrollQuery build(RestRepository client, ScrollReader reader) {
        String scrollUri = this.assemble();
        this.bodyQuery = QueryUtils.applyFilters(this.IS_ES_50, this.bodyQuery, this.filters);
        return client.scanLimit(scrollUri, this.bodyQuery, this.limit, reader);
    }

    public String toString() {
        return "QueryBuilder [" + this.assemble() + "]";
    }

    public QueryBuilder restrictToNode(boolean onlyNode) {
        this.onlyNode = onlyNode;
        return this;
    }
}

