/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String EMPTY = "";

    public static boolean hasLength(CharSequence sequence) {
        return sequence != null && sequence.length() > 0;
    }

    public static boolean hasText(CharSequence sequence) {
        if (!StringUtils.hasLength(sequence)) {
            return false;
        }
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static List<String> tokenize(String string) {
        return StringUtils.tokenize(string, ",");
    }

    public static List<String> tokenize(String string, String delimiters) {
        return StringUtils.tokenize(string, delimiters, true, true);
    }

    public static List<String> tokenize(String string, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (string == null) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(string, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String concatenate(Collection<?> list, String delimiter) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : list) {
            sb.append(object.toString());
            sb.append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static String concatenate(Object[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String deleteWhitespace(CharSequence sequence) {
        if (!StringUtils.hasLength(sequence)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char currentChar = sequence.charAt(i);
            if (Character.isWhitespace(currentChar)) continue;
            sb.append(currentChar);
        }
        return sb.length() == sequence.length() ? sequence.toString() : sb.toString();
    }

    public static boolean isLowerCase(CharSequence string) {
        for (int index = 0; index < string.length(); ++index) {
            if (!Character.isUpperCase(string.charAt(index))) continue;
            return false;
        }
        return true;
    }
}

