/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.am;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.elasticsearch.hadoop.yarn.am.AppMasterRpc;
import org.elasticsearch.hadoop.yarn.am.EsCluster;
import org.elasticsearch.hadoop.yarn.cfg.Config;
import org.elasticsearch.hadoop.yarn.util.Assert;
import org.elasticsearch.hadoop.yarn.util.PropertiesUtils;
import org.elasticsearch.hadoop.yarn.util.YarnUtils;

public class ApplicationMaster
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(ApplicationMaster.class);
    private ApplicationAttemptId appId;
    private final Map<String, String> env;
    private AppMasterRpc rpc;
    private final Configuration cfg;
    private EsCluster cluster;
    private NMTokenCache nmTokenCache;
    private final Config appConfig;
    private RegisterApplicationMasterResponse amResponse;

    ApplicationMaster(Map<String, String> env) {
        this.env = env;
        this.cfg = new YarnConfiguration();
        if (env.containsKey("ES_YARN_FS_URI")) {
            this.cfg.set("fs.defaultFS", env.get("ES_YARN_FS_URI"));
        }
        this.appConfig = new Config(PropertiesUtils.propsFromBase64String(env.get("ES_YARN_CFG_PROPERTIES")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        log.info((Object)"Starting ApplicationMaster...");
        if (this.nmTokenCache == null) {
            this.nmTokenCache = new NMTokenCache();
        }
        if (this.rpc == null) {
            this.rpc = new AppMasterRpc(this.cfg, this.nmTokenCache);
            this.rpc.start();
        }
        this.appId = YarnUtils.getApplicationAttemptId(this.env);
        Assert.notNull(this.appId, "ApplicationAttemptId cannot be found in env %s" + this.env);
        this.amResponse = this.rpc.registerAM();
        this.updateTokens();
        this.cluster = new EsCluster(this.rpc, this.appConfig, this.env);
        try {
            this.cluster.start();
        }
        finally {
            this.close();
        }
    }

    private void updateTokens() {
        for (NMToken nmToken : this.amResponse.getNMTokensFromPreviousAttempts()) {
            this.nmTokenCache.setToken(nmToken.getNodeId().toString(), nmToken.getToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean hasFailed = this.cluster == null || this.cluster.hasFailed();
        try {
            if (this.cluster != null) {
                this.cluster.close();
                this.cluster = null;
            }
        }
        finally {
            if (this.amResponse != null) {
                this.updateTokens();
            }
            if (hasFailed) {
                this.rpc.failAM();
            } else {
                this.rpc.finishAM();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ApplicationMaster am = new ApplicationMaster(System.getenv());
        try {
            am.run();
        }
        finally {
            am.close();
        }
    }
}

