/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

public class Resource {
    private final String indexAndType;
    private final String type;
    private final String index;
    private final String bulk;
    private final String refresh;

    public Resource(Settings settings, boolean read) {
        String res;
        int slash;
        String resource = read ? settings.getResourceRead() : settings.getResourceWrite();
        String errorMessage = "invalid resource given; expecting [index]/[type] - received ";
        Assert.hasText(resource, errorMessage + resource);
        if (resource.contains("?") || resource.contains("&")) {
            if (StringUtils.hasText(settings.getQuery())) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot specify a query in the target index AND through %s", "es.query"));
            }
            int index = resource.indexOf("?");
            if (index > 0) {
                String query = resource.substring(index);
                resource = (index = (resource = resource.substring(0, index)).lastIndexOf("/")) > 0 ? resource.substring(0, index) : resource;
                settings.setProperty("es.resource", resource);
                settings.setQuery(query);
            }
        }
        if ((slash = (res = StringUtils.sanitizeResource(resource)).indexOf("/")) < 0) {
            this.index = res;
            this.type = "";
        } else {
            this.index = res.substring(0, slash);
            this.type = res.substring(slash + 1);
            Assert.hasText(this.type, "No type found; expecting [index]/[type]");
        }
        Assert.hasText(this.index, "No index found; expecting [index]/[type]");
        Assert.isTrue(!StringUtils.hasWhitespace(this.index) && !StringUtils.hasWhitespace(this.type), "Index and type should not contain whitespaces");
        this.indexAndType = this.index + "/" + this.type;
        this.bulk = this.indexAndType.contains("{") ? "/_bulk" : this.indexAndType + "/_bulk";
        this.refresh = this.index.contains("{") ? "/_refresh" : this.index + "/_refresh";
    }

    String bulk() {
        return this.bulk;
    }

    String mapping() {
        return this.indexAndType + "/_mapping";
    }

    String aliases() {
        return this.index + "/_aliases";
    }

    String indexAndType() {
        return this.indexAndType;
    }

    String type() {
        return this.type;
    }

    String index() {
        return this.index;
    }

    public String toString() {
        return this.indexAndType;
    }

    public String refresh() {
        return this.refresh;
    }
}

