/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.FieldType;

public class Field
implements Serializable {
    private static final Field[] NO_FIELDS = new Field[0];
    private final String name;
    private final FieldType type;
    private final Field[] properties;

    public Field(String name, FieldType type) {
        this(name, type, NO_FIELDS);
    }

    public Field(String name, FieldType type, Collection<Field> properties) {
        this(name, type, properties != null ? properties.toArray(new Field[properties.size()]) : NO_FIELDS);
    }

    Field(String name, FieldType type, Field[] properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
    }

    public Field[] properties() {
        return this.properties;
    }

    public FieldType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public static Field parseField(Map<String, Object> content) {
        Iterator<Map.Entry<String, Object>> iterator = content.entrySet().iterator();
        return iterator.hasNext() ? Field.parseField(iterator.next(), null) : null;
    }

    public Field skipHeaders() {
        return Field.skipHeaders(this);
    }

    private static Field skipHeaders(Field field) {
        Field[] props = field.properties();
        if (props.length > 0 && props[0] != null && "mappings".equals(props[0].name()) && FieldType.OBJECT.equals((Object)props[0].type())) {
            return props[0].properties()[0];
        }
        return field;
    }

    public static Map<String, FieldType> toLookupMap(Field field) {
        if (field == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldType> map = new LinkedHashMap<String, FieldType>();
        for (Field nestedField : Field.skipHeaders(field).properties()) {
            Field.add(map, nestedField, null);
        }
        return map;
    }

    static void add(Map<String, FieldType> fields, Field field, String parentName) {
        String fieldName = parentName != null ? parentName + "." + field.name() : field.name();
        fields.put(fieldName, field.type());
        if (FieldType.OBJECT == field.type()) {
            for (Field nestedField : field.properties()) {
                Field.add(fields, nestedField, fieldName);
            }
        }
    }

    private static Field parseField(Map.Entry<String, Object> entry, String previousKey) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Map) {
            Map content = (Map)value;
            Object type = content.get("type");
            if (type instanceof String) {
                String typeString = type.toString();
                FieldType fieldType = FieldType.parse(typeString);
                if (FieldType.MULTI_FIELD == fieldType) {
                    Map map = (Map)content.get("fields");
                    Map defaultField = (Map)map.get(key);
                    FieldType defaultType = null;
                    if (defaultField == null) {
                        String defaultFieldName = null;
                        for (Map.Entry subfield : map.entrySet()) {
                            Map subFieldDef = (Map)subfield.getValue();
                            FieldType subFieldType = FieldType.parse(subFieldDef.get("type").toString());
                            if (defaultType != null) {
                                if (defaultType == subFieldType) continue;
                                throw new EsHadoopIllegalArgumentException(String.format("Ambiguous mapping, multi_field [%s] provides no default field and subfields have different mapping types [%s=%s], [%s=%s]", new Object[]{key, defaultFieldName, defaultType, subfield.getKey(), subFieldType}));
                            }
                            defaultFieldName = (String)subfield.getKey();
                            defaultType = subFieldType;
                        }
                    } else {
                        defaultType = FieldType.parse(defaultField.get("type").toString());
                    }
                    return new Field(key, defaultType);
                }
                if (FieldType.isRelevant(fieldType)) {
                    return new Field(key, fieldType);
                }
                return null;
            }
            ArrayList<Field> fields = new ArrayList<Field>(content.size());
            for (Map.Entry<String, Object> entry2 : content.entrySet()) {
                if (!(entry2.getValue() instanceof Map)) continue;
                Field fl = Field.parseField(entry2, key);
                if (fl != null && fl.type == FieldType.OBJECT && "properties".equals(fl.name)) {
                    return new Field(key, fl.type, fl.properties);
                }
                if (fl == null) continue;
                fields.add(fl);
            }
            return new Field(key, FieldType.OBJECT, fields);
        }
        throw new EsHadoopIllegalArgumentException("invalid map received " + entry);
    }

    public String toString() {
        return String.format("%s=%s", this.name, this.type == FieldType.OBJECT ? Arrays.toString(this.properties) : this.type);
    }
}

