/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.io.Closeable;

public interface Parser
extends Closeable {
    public Token currentToken();

    public Token nextToken();

    public void skipChildren();

    public String currentName();

    public Object currentValue();

    public String text();

    public byte[] bytes();

    public Number numberValue();

    public NumberType numberType();

    public short shortValue();

    public int intValue();

    public long longValue();

    public float floatValue();

    public double doubleValue();

    public boolean booleanValue();

    public byte[] binaryValue();

    @Override
    public void close();

    public int tokenCharOffset();

    public static enum NumberType {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BIG_INTEGER,
        BIG_DECIMAL;

    }

    public static enum Token {
        START_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_OBJECT{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        START_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        END_ARRAY{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        FIELD_NAME{

            @Override
            public boolean isValue() {
                return false;
            }
        }
        ,
        VALUE_STRING{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NUMBER{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_BOOLEAN{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_EMBEDDED_OBJECT{

            @Override
            public boolean isValue() {
                return true;
            }
        }
        ,
        VALUE_NULL{

            @Override
            public boolean isValue() {
                return true;
            }
        };


        public abstract boolean isValue();
    }
}

