/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util.regex;

import java.util.List;

public class Regex {
    public static boolean isSimpleMatchPattern(String str) {
        return str.indexOf(42) != -1;
    }

    public static boolean isMatchAllPattern(String str) {
        return str.equals("*");
    }

    public static boolean simpleMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, firstIndex + 1);
            if (nextIndex == -1) {
                return str.endsWith(pattern.substring(1));
            }
            if (nextIndex == 1) {
                return Regex.simpleMatch(pattern.substring(1), str);
            }
            String part = pattern.substring(1, nextIndex);
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (Regex.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.length() >= firstIndex && pattern.substring(0, firstIndex).equals(str.substring(0, firstIndex)) && Regex.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex));
    }

    public static boolean simpleMatch(List<String> patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!Regex.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean simpleMatch(List<String> patterns, String[] types) {
        if (patterns != null && types != null) {
            for (String type : types) {
                for (String pattern : patterns) {
                    if (!Regex.simpleMatch(pattern, type)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

