/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.util.Assert;

public abstract class ObjectUtils {
    public static <T> T instantiate(String className, ClassLoader loader) {
        Assert.hasText(className, "No class name given");
        ClassLoader cl = loader != null ? loader : ObjectUtils.class.getClassLoader();
        Class<?> clz = null;
        try {
            clz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EsHadoopIllegalStateException(String.format("Cannot load class [%s]", className), e);
        }
        try {
            return (T)clz.newInstance();
        }
        catch (Exception ex) {
            throw new EsHadoopIllegalStateException(String.format("Cannot instantiate class [%s]", className), ex);
        }
    }

    public static <T> T instantiate(String className, Settings settings) {
        return ObjectUtils.instantiate(className, null, settings);
    }

    public static <T> T instantiate(String className, ClassLoader loader, Settings settings) {
        T obj = ObjectUtils.instantiate(className, loader);
        if (obj instanceof SettingsAware) {
            ((SettingsAware)obj).setSettings(settings);
        }
        return obj;
    }

    public static boolean isClassPresent(String className, ClassLoader cl) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className, false, cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clz != null;
    }

    public static Class<?> loadClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot load class [%s]", className), ex);
        }
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

