/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.QueryBuilder;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.dto.Shard;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.Version;

public abstract class RestService
implements Serializable {
    /*
     * Enabled aggressive block sorting
     */
    public static List<PartitionDefinition> findPartitions(Settings settings, Log log) {
        boolean overlappingShards = false;
        Map targetShards = null;
        InitializationUtils.discoverNodesIfNeeded(settings, log);
        InitializationUtils.filterNonClientNodesIfNeeded(settings, log);
        InitializationUtils.discoverEsVersion(settings, log);
        String savedSettings = settings.save();
        RestRepository client = new RestRepository(settings);
        boolean indexExists = client.indexExists(true);
        if (!indexExists) {
            if (!settings.getIndexReadMissingAsEmpty()) {
                client.close();
                throw new EsHadoopIllegalArgumentException(String.format("Index [%s] missing and settings [%s] is set to false", settings.getResourceRead(), "es.field.read.empty.as.null"));
            }
            log.info((Object)String.format("Index [%s] missing - treating it as empty", settings.getResourceRead()));
            targetShards = Collections.emptyMap();
        } else {
            Object[] result = client.getReadTargetShards(settings.getNodesClientOnly());
            overlappingShards = (Boolean)result[0];
            targetShards = (Map)result[1];
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating splits for shards " + targetShards));
            }
        }
        Version.logVersion();
        log.info((Object)String.format("Reading from [%s]", settings.getResourceRead()));
        String savedMapping = null;
        if (!targetShards.isEmpty()) {
            Field mapping = client.getMapping();
            log.info((Object)String.format("Discovered mapping {%s} for [%s]", mapping, settings.getResourceRead()));
            FieldPresenceValidation validation = settings.getFieldExistanceValidation();
            if (validation.isRequired()) {
                MappingUtils.validateMapping(settings.getScrollFields(), mapping, validation, log);
            }
            savedMapping = IOUtils.serializeToBase64(mapping);
        }
        client.close();
        ArrayList<PartitionDefinition> partitions = new ArrayList<PartitionDefinition>(targetShards.size());
        Iterator i$ = targetShards.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            partitions.add(new PartitionDefinition((Shard)entry.getKey(), (Node)entry.getValue(), savedSettings, savedMapping, !overlappingShards));
        }
        return partitions;
    }

    public static PartitionReader createReader(Settings settings, PartitionDefinition partition, Log log) {
        if (!SettingsUtils.hasPinnedNode(settings)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Partition reader instance [%s] assigned to [%s]:[%s]", partition, partition.nodeId, partition.nodePort));
            }
            SettingsUtils.pinNode(settings, partition.nodeIp, partition.nodePort);
        }
        ValueReader reader = (ValueReader)ObjectUtils.instantiate(settings.getSerializerValueReaderClassName(), settings);
        Field fieldMapping = null;
        if (StringUtils.hasText(partition.serializedMapping)) {
            fieldMapping = (Field)IOUtils.deserializeFromBase64(partition.serializedMapping);
        } else {
            log.warn((Object)String.format("No mapping found for [%s] - either no index exists or the partition configuration has been corrupted", partition));
        }
        ScrollReader scrollReader = new ScrollReader(reader, fieldMapping, settings.getReadMetadata(), settings.getReadMetadataField(), settings.getOutputAsJson());
        RestRepository client = new RestRepository(settings);
        if (settings.getNodesClientOnly()) {
            String clientNode = client.getRestClient().getCurrentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Client-node routing detected; partition reader instance [%s] assigned to [%s]", partition, clientNode));
            }
            SettingsUtils.pinNode(settings, clientNode);
        }
        QueryBuilder queryBuilder = QueryBuilder.query(settings).shard(partition.shardId).node(partition.nodeId).restrictToNode(partition.onlyNode && !settings.getNodesClientOnly());
        queryBuilder.fields(settings.getScrollFields());
        queryBuilder.filter(SettingsUtils.getFilters(settings));
        return new PartitionReader(scrollReader, client, queryBuilder);
    }

    public static List<PartitionDefinition> assignPartitions(List<PartitionDefinition> partitions, int currentTask, int totalTasks) {
        int esPartitions = partitions.size();
        if (totalTasks >= esPartitions) {
            return currentTask >= esPartitions ? Collections.emptyList() : Collections.singletonList(partitions.get(currentTask));
        }
        int partitionsPerTask = esPartitions / totalTasks;
        int remainder = esPartitions % totalTasks;
        int partitionsPerCurrentTask = partitionsPerTask;
        if (currentTask < remainder) {
            ++partitionsPerCurrentTask;
        }
        int offset = partitionsPerTask * currentTask;
        if (currentTask != 0) {
            offset += remainder > currentTask ? 1 : remainder;
        }
        if (partitionsPerCurrentTask == 1) {
            return Collections.singletonList(partitions.get(offset));
        }
        ArrayList<PartitionDefinition> pa = new ArrayList<PartitionDefinition>(partitionsPerCurrentTask);
        for (int index = offset; index < offset + partitionsPerCurrentTask; ++index) {
            pa.add(partitions.get(index));
        }
        return pa;
    }

    public static MultiReaderIterator multiReader(Settings settings, List<PartitionDefinition> definitions, Log log) {
        return new MultiReaderIterator(definitions, settings, log);
    }

    public static PartitionWriter createWriter(Settings settings, int currentSplit, int totalSplits, Log log) {
        InitializationUtils.discoverNodesIfNeeded(settings, log);
        InitializationUtils.filterNonClientNodesIfNeeded(settings, log);
        InitializationUtils.discoverEsVersion(settings, log);
        List<String> nodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
        int selectedNode = currentSplit < 0 ? new Random().nextInt(nodes.size()) : currentSplit % nodes.size();
        SettingsUtils.pinNode(settings, nodes.get(selectedNode));
        Resource resource = new Resource(settings, false);
        Version.logVersion();
        log.info((Object)String.format("Writing to [%s]", resource));
        IndexExtractor iformat = (IndexExtractor)ObjectUtils.instantiate(settings.getMappingIndexExtractorClassName(), settings);
        iformat.compile(resource.toString());
        RestRepository repository = iformat.hasPattern() ? RestService.initMultiIndices(settings, currentSplit, resource, log) : RestService.initSingleIndex(settings, currentSplit, resource, log);
        return new PartitionWriter(settings, currentSplit, totalSplits, repository);
    }

    private static RestRepository initSingleIndex(Settings settings, int currentInstance, Resource resource, Log log) {
        RestRepository repository;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resource [%s] resolves as a single index", resource));
        }
        if ((repository = new RestRepository(settings)).touch() && repository.waitForYellow()) {
            log.warn((Object)String.format("Timed out waiting for index [%s] to reach yellow health", resource));
        }
        if (settings.getNodesClientOnly()) {
            String clientNode = repository.getRestClient().getCurrentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Client-node routing detected; partition writer instance [%s] assigned to [%s]", currentInstance, clientNode));
            }
            return repository;
        }
        Map<Object, Object> targetShards = Collections.emptyMap();
        targetShards = repository.getWriteTargetPrimaryShards(settings.getNodesClientOnly());
        repository.close();
        Assert.isTrue(!targetShards.isEmpty(), String.format("Cannot determine write shards for [%s]; likely its format is incorrect (maybe it contains illegal characters?)", resource));
        ArrayList<Object> orderedShards = new ArrayList<Object>(targetShards.keySet());
        Collections.sort(orderedShards);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Partition writer instance [%s] discovered [%s] primary shards %s", currentInstance, orderedShards.size(), orderedShards));
        }
        if (currentInstance <= 0) {
            currentInstance = new Random().nextInt(targetShards.size()) + 1;
        }
        int bucket = currentInstance % targetShards.size();
        Shard chosenShard = (Shard)orderedShards.get(bucket);
        Node targetNode = (Node)targetShards.get(chosenShard);
        SettingsUtils.pinNode(settings, targetNode.getIpAddress(), targetNode.getHttpPort());
        String node = SettingsUtils.getPinnedNode(settings);
        repository = new RestRepository(settings);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Partition writer instance [%s] assigned to primary shard [%s] at address [%s]", currentInstance, chosenShard.getName(), node));
        }
        return repository;
    }

    private static RestRepository initMultiIndices(Settings settings, int currentInstance, Resource resource, Log log) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resource [%s] resolves as an index pattern", resource));
        }
        List<String> nodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
        String node = nodes.get(new Random().nextInt(nodes.size()));
        SettingsUtils.pinNode(settings, node);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Partition writer instance [%s] assigned to [%s]", currentInstance, node));
        }
        return new RestRepository(settings);
    }

    public static class MultiReaderIterator
    implements Closeable,
    Iterator {
        private final List<PartitionDefinition> definitions;
        private final Iterator<PartitionDefinition> definitionIterator;
        private PartitionReader currentReader;
        private ScrollQuery currentScroll;
        private boolean finished = false;
        private final Settings settings;
        private final Log log;

        MultiReaderIterator(List<PartitionDefinition> defs, Settings settings, Log log) {
            this.definitions = defs;
            this.definitionIterator = defs.iterator();
            this.settings = settings;
            this.log = log;
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            ScrollQuery sq = this.getCurrent();
            if (sq != null) {
                sq.close();
            }
            if (this.currentReader != null) {
                this.currentReader.close();
            }
            this.finished = true;
        }

        @Override
        public boolean hasNext() {
            ScrollQuery sq = this.getCurrent();
            return sq != null ? sq.hasNext() : false;
        }

        private ScrollQuery getCurrent() {
            if (this.finished) {
                return null;
            }
            boolean hasValue = false;
            while (!hasValue) {
                if (this.currentReader == null) {
                    if (this.definitionIterator.hasNext()) {
                        this.currentReader = RestService.createReader(this.settings, this.definitionIterator.next(), this.log);
                    } else {
                        this.finished = true;
                        return null;
                    }
                }
                if (this.currentScroll == null) {
                    this.currentScroll = this.currentReader.scrollQuery();
                }
                if (hasValue = this.currentScroll.hasNext()) continue;
                this.currentScroll.close();
                this.currentScroll = null;
                this.currentReader.close();
                this.currentReader = null;
            }
            return this.currentScroll;
        }

        public Object[] next() {
            ScrollQuery sq = this.getCurrent();
            return sq.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PartitionWriter
    implements Closeable {
        public final RestRepository repository;
        public final int number;
        public final int total;
        public final Settings settings;
        private boolean closed = false;

        PartitionWriter(Settings settings, int splitIndex, int splitsSize, RestRepository repository) {
            this.settings = settings;
            this.repository = repository;
            this.number = splitIndex;
            this.total = splitsSize;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.repository.close();
            }
        }
    }

    public static class PartitionReader
    implements Closeable {
        public final ScrollReader scrollReader;
        public final RestRepository client;
        public final QueryBuilder queryBuilder;
        private ScrollQuery scrollQuery;
        private boolean closed = false;

        PartitionReader(ScrollReader scrollReader, RestRepository client, QueryBuilder queryBuilder) {
            this.scrollReader = scrollReader;
            this.client = client;
            this.queryBuilder = queryBuilder;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                if (this.scrollQuery != null) {
                    this.scrollQuery.close();
                }
                this.client.close();
            }
        }

        public ScrollQuery scrollQuery() {
            if (this.scrollQuery == null) {
                this.scrollQuery = this.queryBuilder.build(this.client, this.scrollReader);
            }
            return this.scrollQuery;
        }
    }

    public static class PartitionDefinition
    implements Serializable {
        public final String serializedSettings;
        public final String serializedMapping;
        public final String nodeIp;
        public final String nodeId;
        public final String nodeName;
        public final String shardId;
        public final int nodePort;
        public final boolean onlyNode;

        PartitionDefinition(Shard shard, Node node, String settings, String mapping, boolean onlyNode) {
            this(node.getIpAddress(), node.getHttpPort(), node.getName(), node.getId(), shard.getName().toString(), onlyNode, settings, mapping);
        }

        public PartitionDefinition(String nodeIp, int nodePort, String nodeName, String nodeId, String shardId, boolean onlyNode, String settings, String mapping) {
            this.nodeIp = nodeIp;
            this.nodePort = nodePort;
            this.nodeName = nodeName;
            this.nodeId = nodeId;
            this.shardId = shardId;
            this.serializedSettings = settings;
            this.serializedMapping = mapping;
            this.onlyNode = onlyNode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EsPartition [node=[").append(this.nodeId).append("/").append(this.nodeName).append("|").append(this.nodeIp).append(":").append(this.nodePort).append("],shard=").append(this.shardId).append("]");
            return builder.toString();
        }

        public Settings settings() {
            return new PropertiesSettings(new Properties()).load(this.serializedSettings);
        }
    }
}

